# sitelib for noarch packages, sitearch for others (remove the unneeded one)
#%%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}

Name:           python-greenlet
Version:        0.4.2
%define base_release .4
Release:        1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        Lightweight in-process concurrent programming
Group:          Development/Libraries
License:        MIT
URL:            http://pypi.python.org/pypi/greenlet
Source0:        http://pypi.python.org/packages/source/g/greenlet/greenlet-%{version}.zip

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  python2-devel
BuildRequires:  python-setuptools

%description
The greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called "tasklets". Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads)
and are synchronized with data exchanges on "channels".

%package devel
Summary:        C development headers for python-greenlet
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}

%description devel
This package contains header files required for C modules development.

%prep
%setup -q -n greenlet-%{version}

%build
CFLAGS="$RPM_OPT_FLAGS" %{__python} setup.py build
chmod 644 benchmarks/*.py

%install
rm -rf %{buildroot}
%{__python} setup.py install -O1 --skip-build --root %{buildroot}
 
%clean
rm -rf %{buildroot}

# Base commented out test since it fails
# FIXME!!
# The checks segfault on ppc. So this arch
# is essentially not supported until this is fixed
%ifnarch ppc s390 s390x
#%check
# Run the upstream test suite:
#%{__python} setup.py test

# Run the upstream benchmarking suite to further exercise the code:
#PYTHONPATH=$(pwd) %{__python} benchmarks/chain.py
%endif

%files
%defattr(-,root,root,-)
%doc doc/greenlet.txt README.rst benchmarks AUTHORS NEWS
%{python_sitearch}/greenlet.so
%{python_sitearch}/greenlet*.egg-info

%files devel
%defattr(-,root,root,-)
%{_includedir}/python*/greenlet

%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
