Name: yajl
Version: 2.0.4
%define base_release .4
Release: 2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
Summary: Yet Another JSON Library (YAJL)

Group: Development/Libraries
License: ISC
URL: http://lloyd.github.com/yajl/

#
# NB, upstream does not provide pre-built tar.gz downloads. Instead
# they make you use the 'on the fly' generated tar.gz from GITHub's
# web interface
#
# The Source0 for any version is obtained by a URL
#
#   http://github.com/lloyd/yajl/tarball/1.0.7
#
# Which causes a download of a archive named after
# the GIT hash corresponding to the version tag
#
#   eg lloyd-yajl-45a1bdb.tar.gz
#
# NB even though the tar.gz is generated on the fly by GITHub it
# will always have identical md5sum
#
# So for new versions, update 'githash' to match the hash of the
# GIT tag associated with updated 'Version:' field just above
%global githash fee1ebe
Source0: lloyd-%{name}-%{version}-0-g%{githash}.tar.gz
Source999: fivextra.tar.bz2
Patch1: lloyd-%{name}-%{version}-pkgconfig-location.patch
Patch2: lloyd-%{name}-%{version}-pkgconfig-includedir.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: cmake

%package devel
Summary: Libraries, includes, etc to develop with YAJL
Requires: %{name} = %{version}-%{release}

%description
Yet Another JSON Library. YAJL is a small event-driven
(SAX-style) JSON parser written in ANSI C, and a small
validating JSON generator.

%description devel
Yet Another JSON Library. YAJL is a small event-driven
(SAX-style) JSON parser written in ANSI C, and a small
validating JSON generator.

This sub-package provides the libraries and includes
necessary for developing against the YAJL library

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: rpm ruby ruby-libs

%description fivextra
This package contains the testcases built from the package for %{name} 

%prep
%setup -q -n lloyd-%{name}-%{githash} -a 999
%patch1 -p1
%patch2 -p1

%build
# NB, we are not using upstream's 'configure'/'make'
# wrapper, instead we use cmake directly to better
# align with Fedora standards
mkdir build
cd build
%cmake  -DCMAKE_C_COMPILER:FILEPATH=%{__cc} -DCMAKE_CXX_COMPILER:FILEPATH=%{__cxx} ..
make VERBOSE=1 %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
cd build
make install DESTDIR=$RPM_BUILD_ROOT

install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/test
install  $(find test/yajl_test -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/test

# No static libraries
rm -f $RPM_BUILD_ROOT%{_libdir}/libyajl_s.a

pushd ..

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in $(find test -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done  

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 

popd 

%check
cd test
./run_tests.sh

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING ChangeLog README TODO
%{_bindir}/json_reformat
%{_bindir}/json_verify
%{_libdir}/libyajl.so.2
%{_libdir}/libyajl.so.2.*

%files devel
%defattr(-,root,root,-)
%doc COPYING
%dir %{_includedir}/yajl
%{_includedir}/yajl/yajl_common.h
%{_includedir}/yajl/yajl_gen.h
%{_includedir}/yajl/yajl_parse.h
%{_includedir}/yajl/yajl_tree.h
%{_includedir}/yajl/yajl_version.h
%{_libdir}/libyajl.so
%{_libdir}/pkgconfig/yajl.pc

%files fivextra
%{prefix}

%changelog
* Tue Jul 02 2013 baseuser@ibm.com
- Base-8.x spec file
