%if 0%{?fedora} > 12 && ! 0%{?base:1}
%global with_python3 1
%endif

%if ! 0%{?cross_build}
# LTC: pkg-config needs this to be called "-1.9" explicitly. hopefully we can fix when we build ruby for base.
%define ruby_inc %(pkg-config --cflags ruby-1.9)
%define ruby_sitearch %(ruby -rrbconfig -e "puts RbConfig::CONFIG['vendorarchdir']")
%{!?python_sitearch: %define python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%endif
%define libsepolver 2.1.9-1

Summary: SELinux library and simple utilities
Name: libselinux
Version: 2.1.13
%define base_release .5
Release: 15%{?dist}%{?base_release}
License: Public Domain
Group: System Environment/Libraries
Source: %{name}-%{version}.tgz
Source1: selinuxconlist.8
Source2: selinuxdefcon.8
Url: http://oss.tresys.com/git/selinux.git
Patch1: libselinux-rhat.patch
# Base patches
Patch67956: bug67956-adjust-tls-flags.patch
%if ! 0%{?cross_build}
BuildRequires: pkgconfig python-devel ruby-devel ruby libsepol-static >= %{libsepolver} swig pcre-devel
%else
BuildRequires: pkgconfig libsepol-static >= %{libsepolver} swig pcre-devel
%endif
%if 0%{?with_python3}
BuildRequires: python3-devel
%endif # if with_python3
Requires: libsepol >= %{libsepolver} pcre
Conflicts: filesystem < 3
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Security-enhanced Linux is a feature of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

libselinux provides an API for SELinux applications to get and set
process and file security contexts and to obtain security policy
decisions.  Required for any applications that use the SELinux API.

%package utils
Summary: SELinux libselinux utilies
Group: Development/Libraries
Requires: libselinux = %{version}-%{release} 

%description utils
The libselinux-utils package contains the utilities

%if ! 0%{?cross_build}

%package python
Summary: SELinux python bindings for libselinux
Group: Development/Libraries
Requires: libselinux = %{version}-%{release} 

%description python
The libselinux-python package contains the python bindings for developing 
SELinux applications. 

%if 0%{?with_python3}
%package python3
Summary: SELinux python 3 bindings for libselinux
Group: Development/Libraries
Requires: libselinux = %{version}-%{release} 

%description python3
The libselinux-python3 package contains python 3 bindings for developing
SELinux applications. 
%endif # with_python3

%package ruby
Summary: SELinux ruby bindings for libselinux
Group: Development/Libraries
Requires: libselinux = %{version}-%{release} 
Provides: ruby(selinux)

%description ruby
The libselinux-ruby package contains the ruby bindings for developing 
SELinux applications. 

%endif # end not cross_build

%package devel
Summary: Header files and libraries used to build SELinux
Group: Development/Libraries
Requires: libselinux = %{version}-%{release} 
Requires: libsepol-devel >= %{libsepolver}

%description devel
The libselinux-devel package contains the libraries and header files
needed for developing SELinux applications. 

%package static
Summary: Static libraries used to build SELinux
Group: Development/Libraries
Requires: libselinux-devel = %{version}-%{release}

%description static
The libselinux-static package contains the static libraries
needed for developing SELinux applications. 

%prep
%setup -q
%patch1 -p2 -b .rhat
%patch67956 -p1

%build
export CC=%{__cc}
# To support building the Python wrapper against multiple Python runtimes
# Define a function, for how to perform a "build" of the python wrapper against
# a specific runtime:
BuildPythonWrapper() {
  BinaryName=$1

  # Perform the build from the upstream Makefile:
  make \
    PYTHON=$BinaryName \
    LIBDIR="%{_libdir}" CFLAGS="-g %{optflags} %{?base:-I/usr/include/python2.6}" %{?_smp_mflags} \
    pywrap
}

make clean
make LIBDIR="%{_libdir}" CFLAGS="-g %{optflags}" %{?_smp_mflags} swigify
make LIBDIR="%{_libdir}" CFLAGS="-g %{optflags}" %{?_smp_mflags} all

%if ! 0%{?cross_build}
BuildPythonWrapper %{__python}
%if 0%{?with_python3}
BuildPythonWrapper %{__python3}
%endif # with_python3

make RUBYINC="%{ruby_inc}" SHLIBDIR="%{_libdir}" LIBDIR="%{_libdir}" CFLAGS="-g %{optflags}" %{?_smp_mflags} rubywrap
%endif # end not cross_build

%install
InstallPythonWrapper() {
  BinaryName=$1

  make \
    PYTHON=$BinaryName \
    LIBDIR="%{_libdir}" CFLAGS="-g %{optflags}" %{?_smp_mflags} \
    pywrap

  make \
    PYTHON=$BinaryName \
    DESTDIR="%{buildroot}" LIBDIR="%{buildroot}%{_libdir}" \
    SHLIBDIR="%{buildroot}/%{_lib}" BINDIR="%{buildroot}%{_bindir}" \
    SBINDIR="%{buildroot}%{_sbindir}" \
    install-pywrap
}

rm -rf %{buildroot}
mkdir -p %{buildroot}/%{_lib} 
mkdir -p %{buildroot}/%{_libdir} 
mkdir -p %{buildroot}%{_includedir} 
mkdir -p %{buildroot}%{_sbindir}
mkdir -p %{buildroot}/var/run/setrans
mkdir -p %{buildroot}/usr/lib/tmpfiles.d
echo "d /var/run/setrans 0755 root root" > %{buildroot}/usr/lib/tmpfiles.d/libselinux.conf

%if 0%{?cross_build}
make DESTDIR="%{buildroot}" LIBDIR="%{buildroot}%{_libdir}" SHLIBDIR="%{buildroot}%{_libdir}" BINDIR="%{buildroot}%{_bindir}" SBINDIR="%{buildroot}%{_sbindir}" install
%else
InstallPythonWrapper %{__python}
%if 0%{?with_python3}
InstallPythonWrapper %{__python3}
%endif # with_python3

make DESTDIR="%{buildroot}" LIBDIR="%{buildroot}%{_libdir}" SHLIBDIR="%{buildroot}%{_libdir}" BINDIR="%{buildroot}%{_bindir}" SBINDIR="%{buildroot}%{_sbindir}" RUBYINSTALL=%{buildroot}%{ruby_sitearch} install install-rubywrap
%endif # end cross_build

# Nuke the files we don't want to distribute
rm -f %{buildroot}%{_sbindir}/compute_*
rm -f %{buildroot}%{_sbindir}/deftype
rm -f %{buildroot}%{_sbindir}/execcon
rm -f %{buildroot}%{_sbindir}/getenforcemode
rm -f %{buildroot}%{_sbindir}/getfilecon
rm -f %{buildroot}%{_sbindir}/getpidcon
rm -f %{buildroot}%{_sbindir}/mkdircon
rm -f %{buildroot}%{_sbindir}/policyvers
rm -f %{buildroot}%{_sbindir}/setfilecon
rm -f %{buildroot}%{_sbindir}/selinuxconfig
rm -f %{buildroot}%{_sbindir}/selinuxdisable
rm -f %{buildroot}%{_sbindir}/getseuser
rm -f %{buildroot}%{_sbindir}/togglesebool
rm -f %{buildroot}%{_sbindir}/selinux_check_securetty_context
mv %{buildroot}%{_sbindir}/getdefaultcon %{buildroot}%{_sbindir}/selinuxdefcon
mv %{buildroot}%{_sbindir}/getconlist %{buildroot}%{_sbindir}/selinuxconlist
install -d %{buildroot}%{_mandir}/man8/
install -m 644 %{SOURCE1} %{buildroot}%{_mandir}/man8/
install -m 644 %{SOURCE2} %{buildroot}%{_mandir}/man8/

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_libdir}/libselinux.so.*
/var/run/setrans
%{_sbindir}/sefcontext_compile
/usr/lib/tmpfiles.d/libselinux.conf

%files utils
%defattr(-,root,root,-)
%{_sbindir}/avcstat
%{_sbindir}/getenforce
%{_sbindir}/getsebool
%{_sbindir}/matchpathcon
%{_sbindir}/selinuxconlist
%{_sbindir}/selinuxdefcon
%{_sbindir}/selinuxexeccon
%{_sbindir}/selinuxenabled
%{_sbindir}/setenforce
%{_mandir}/man5/*
%{_mandir}/man8/*

%files devel
%defattr(-,root,root,-)
%{_libdir}/libselinux.so
%{_libdir}/pkgconfig/libselinux.pc
%dir %{_includedir}/selinux
%{_includedir}/selinux/*
%{_mandir}/man3/*

%files static
%defattr(-,root,root,-)
%{_libdir}/libselinux.a

%if ! 0%{?cross_build}

%files python
%defattr(-,root,root,-)
%dir %{python_sitearch}/selinux
%{python_sitearch}/selinux/*

%if 0%{?with_python3}
%files python3
%defattr(-,root,root,-)
%dir %{python3_sitearch}/selinux
%dir %{python3_sitearch}/selinux/__pycache__
%{python3_sitearch}/selinux/*.py*
%{python3_sitearch}/selinux/*.so
%{python3_sitearch}/selinux/__pycache__/*
%endif with_python3

%files ruby
%defattr(-,root,root,-)
%{ruby_sitearch}/selinux.so

%endif #end not cross_build

%changelog
* Fri May 31 2013 baseuser@ibm.com
- Base-8.x spec file
