%global fontname gnu-free
%global fontconf 69-%{fontname}

Name:      %{fontname}-fonts
Version:   20120503
%define base_release .1
Release:   6%{?dist}%{?base_release}
Summary:   Free UCS Outline Fonts
Group:     User Interface/X
# Standard font exception
License:   GPLv3+ with exceptions
URL:       http://www.gnu.org/software/freefont/ 
Source0:   http://ftp.gnu.org/gnu/freefont/freefont-src-%{version}.tar.gz
Source2:   %{fontconf}-mono.conf
Source3:   %{fontconf}-sans.conf
Source4:   %{fontconf}-serif.conf
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch: noarch
BuildRequires: fontpackages-devel fontforge

%global common_desc \
Gnu FreeFont is a free family of scalable outline fonts, suitable for general \
use on computers and for desktop publishing. It is Unicode-encoded for \
compatibility with all modern operating systems. \
 \
Besides a full set of characters for writing systems based on the Latin \
alphabet, FreeFont contains large selection of characters from other writing \
systems some of which are hard to find elsewhere. \
 \
FreeFont also contains a large set of symbol characters, both technical and \
decorative. We are especially pleased with the Mathematical Operators range, \
with which most of the glyphs used in LaTeX can be displayed.

%description
%common_desc


%package common
Summary:  Common files for freefont (documentation…)
Requires: fontpackages-filesystem
Obsoletes: gnu-free-fonts-compat < 20120503

%description common
%common_desc

This package consists of files used by other %{name} packages.


%package -n %{fontname}-mono-fonts
Summary:  GNU FreeFont Monospaced Font
Requires: %{name}-common = %{version}-%{release}

%description -n %{fontname}-mono-fonts
%common_desc

This package contains the GNU FreeFont monospaced font.


%package -n %{fontname}-sans-fonts
Summary:  GNU FreeFont Sans-Serif Font
Requires: %{name}-common = %{version}-%{release}

%description -n %{fontname}-sans-fonts
%common_desc

This package contains the GNU FreeFont sans-serif font.


%package -n %{fontname}-serif-fonts
Summary:  GNU FreeFont Serif Font
Requires: %{name}-common = %{version}-%{release}

%description -n %{fontname}-serif-fonts
%common_desc

This package contains the GNU FreeFont serif font.


%prep
%setup -qn freefont-%{version}


%build
make

%install
rm -rf %{buildroot}

pushd sfd
install -m 0755 -d %{buildroot}%{_fontdir}
install -p -m 644 *.ttf  %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE2} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-mono.conf

install -m 0644 -p %{SOURCE3} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-sans.conf

install -m 0644 -p %{SOURCE4} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-serif.conf


for fconf in %{fontconf}-mono.conf \
                %{fontconf}-sans.conf \
                %{fontconf}-serif.conf ; do
  ln -s %{_fontconfig_templatedir}/$fconf \
        %{buildroot}%{_fontconfig_confdir}/$fconf
done

%clean
rm -rf %{buildroot}

%_font_pkg -n mono -f %{fontconf}-mono.conf FreeMono*.ttf
%_font_pkg -n sans -f %{fontconf}-sans.conf FreeSans*.ttf
%_font_pkg -n serif -f %{fontconf}-serif.conf FreeSerif*.ttf

%files common
%defattr(0644,root,root,0755)
%doc AUTHORS ChangeLog CREDITS COPYING README

%changelog
* Wed May 28 2014 baseuser@ibm.com
- Base-f19.x spec file
