Name:           augeas
Version:        1.2.0
%define base_release .2
Release:        1%{?dist}%{?base_release}
Summary:        A library for changing configuration files

Group:          System Environment/Libraries
License:        LGPLv2+
URL:            http://augeas.net/
Source0:        http://download.augeas.net/%{name}-%{version}.tar.gz
Source999:      fivextra.tar.bz2

Patch96293:	bug96293-augeas.patch
Patch104528:    bug-104528-fix-case-statement-with-SemicolonSemicolon.patch

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  readline-devel libselinux-devel libxml2-devel
Requires:       %{name}-libs = %{version}-%{release}

%description
A library for programmatically editing configuration files. Augeas parses
configuration files into a tree structure, which it exposes through its
public API. Changes made through the API are written back to the initially
read files.

The transformation works very hard to preserve comments and formatting
details. It is controlled by ``lens'' definitions that describe the file
format and the transformation into a tree.

%package        devel
Summary:        Development files for %{name}
Group:          Development/Libraries
Requires:       %{name}-libs = %{version}-%{release}
Requires:       pkgconfig

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%package        libs
Summary:        Libraries for %{name}
Group:          System Environment/Libraries

%description    libs
The libraries for %{name}.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: graphviz

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%patch96293 -p1
%patch104528 -p1

%build
%configure --disable-static
make %{?_smp_mflags}
make %{?_smp_mflags} check || true

%check
# Disable test-preserve.sh SELinux testing. This fails when run under mock due
# to differing SELinux labelling.
export SKIP_TEST_PRESERVE_SELINUX=1

make %{?_smp_mflags} check || true
# LTC patches not compatible
#make %{?_smp_mflags} check || {
#  echo '===== tests/test-suite.log ====='
#  cat tests/test-suite.log
#  exit 1
#}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="%{__install} -p"
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

# Steps for packaging the 'augeas' tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in `cd lenses; find . -type d -not -name CVS`
do
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/lenses/$dir
install `find lenses/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/lenses/$dir/
done

for dir in `cd tests; find . -type d -not -name CVS`
do
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/$dir
install `find tests/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests/$dir || true
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests -name '*.o' -o -name '*.c' -o -name '*.h' \
 -o -name 'Makefile*' -o -name '*.log' -o -name '.deps' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
mv $RPM_BUILD_ROOT%{fivdir}/%{name}/tests/.libs/test-* $RPM_BUILD_ROOT%{fivdir}/%{name}/tests
popd

# The tests/ subdirectory contains lenses used only for testing, and
# so it shouldn't be packaged.
rm -r $RPM_BUILD_ROOT%{_datadir}/augeas/lenses/dist/tests

%clean
rm -rf $RPM_BUILD_ROOT

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_bindir}/augtool
%{_bindir}/augparse
%{_bindir}/fadot
%doc %{_mandir}/man1/*
%{_datadir}/vim/vimfiles/syntax/augeas.vim
%{_datadir}/vim/vimfiles/ftdetect/augeas.vim

%files libs
%defattr(-,root,root,-)
# %{_datadir}/augeas and %{_datadir}/augeas/lenses are owned
# by filesystem.
%{_datadir}/augeas/lenses/dist
%{_libdir}/*.so.*
%doc AUTHORS COPYING NEWS

%files devel
%defattr(-,root,root,-)
%doc
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/augeas.pc

%files fivextra
%{prefix}

%changelog
* Thu Jan 23 2014 baseuser@ibm.com
- Base-f19.x spec file
