Summary:       A graphics library for quick creation of PNG or JPEG images
Name:          gd
Version:       2.0.35
%define base_release .2
Release:       24%{?dist}%{?base_release}
# MCP: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Group:         System Environment/Libraries
License:       MIT
URL:           http://www.libgd.org/Main_Page
Source0:       http://www.libgd.org/releases/%{name}-%{version}.tar.bz2
Patch0:        gd-2.0.33-freetype.patch
Patch3:        gd-2.0.34-multilib.patch
Patch4:        gd-loop.patch
Patch5:        gd-2.0.34-sparc64.patch
Patch6:        gd-2.0.35-overflow.patch
Patch7:        gd-2.0.35-AALineThick.patch
Patch8:        gd-2.0.33-BoxBound.patch
Patch9:        gd-2.0.34-fonts.patch
Patch10:       gd-2.0.35-time.patch
Patch11:       gd-2.0.35-security3.patch
Patch12:       gd-2.0.35-runtests.patch
Patch13:       gd-sa1.patch
Patch14:       gd-sa2.patch
Patch15:       gd-sa3.patch
Patch16:       gd-sa4.patch
Patch17:       gd-aarch64.patch
BuildRequires: freetype-devel, fontconfig-devel, libX11-devel, libXpm-devel
BuildRequires: libjpeg-devel, libpng-devel, zlib-devel, pkgconfig
# we need cmake for building test suite
BuildRequires: cmake, chrpath

%description
The gd graphics library allows your code to quickly draw images
complete with lines, arcs, text, multiple colors, cut and paste from
other images, and flood fills, and to write out the result as a PNG or
JPEG file. This is particularly useful in Web applications, where PNG
and JPEG are two of the formats accepted for inline images by most
browsers. Note that gd is not a paint program.


%package progs
Requires:       gd = %{version}-%{release}
Summary:        Utility programs that use libgd
Group:          Applications/Multimedia

%description progs
The gd-progs package includes utility programs supplied with gd, a
graphics library for creating PNG and JPEG images. 


%package devel
Summary:  The development libraries and header files for gd
Group:    Development/Libraries
Requires: gd = %{version}-%{release}
Requires: libX11-devel, libXpm-devel, libjpeg-devel, freetype-devel
Requires: libpng-devel, zlib-devel, fontconfig-devel
Requires: pkgconfig

%description devel
The gd-devel package contains the development libraries and header
files for gd, a graphics library for creating PNG and JPEG graphics.

%prep
%setup -q
%patch0 -p1 -b .freetype
%patch3 -p1 -b .mlib
%patch4 -p1 -b .loop
%patch6 -p1 -b .overflow
%patch5 -p1 -b .sparc64 
%patch7 -p1 -b .AALineThick
%patch8 -p1 -b .bb
%patch9 -p1 -b .fonts
%patch10 -p1 -b .time
%patch11 -p1 -b .sec3
%patch12 -p1 -b .runtests
%patch13 -p1 -b .sa1
%patch14 -p1 -b .sa2
%patch15 -p1 -b .sa3
%patch16 -p1 -b .sa4
%patch17 -p1 -b .aarch64

%build
%configure --disable-rpath
make %{?_smp_mflags}

%install
make install INSTALL='install -p' DESTDIR=$RPM_BUILD_ROOT 
rm -f $RPM_BUILD_ROOT/%{_libdir}/libgd.la
rm -f $RPM_BUILD_ROOT/%{_libdir}/libgd.a

# Using the last resort to remove rpath, another tricks didn't help
chrpath --delete $RPM_BUILD_ROOT%{_bindir}/{pngtogd,gdparttopng,annotate,gdcmpgif,gdtopng,webpng,pngtogd2,gd2togif,gd2copypal,giftogd2,gd2topng}

%check
pushd tests
cmake -DBUILD_TEST=1 \
      -DGD_INCLUDE_DIR="`pwd`/.." \
      -DGD_LIBS_DIR="`pwd`/../.libs" \
      -DGD_SOURCE_DIR="`pwd`/.." .
CPATH="`pwd`/gdtest" make
make test
popd

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc COPYING README-JPEG.TXT index.html NEWS
%{_libdir}/*.so.*

%files progs
%{_bindir}/*
%exclude %{_bindir}/gdlib-config

%files devel
%doc index.html
%{_bindir}/gdlib-config
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/gdlib.pc

%changelog
* Mon Jun 03 2013 baseuser@ibm.com
- Base-f19.x spec file
