# For cross, disable python unless --with python is specified.
%if 0%{?cross_build}
%bcond_with python
%else
%bcond_without python
%endif

%if 0%{?with_python}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%endif # with_python
%global __libtoolize :

Summary: A utility for determining file types
Name: file
Version: 5.11
%define base_release .1
Release: 13%{?dist}%{?base_release}
License: BSD
Group: Applications/File
Source0: ftp://ftp.astron.com/pub/file/file-%{version}.tar.gz
Source999: fivextra.tar.bz2
# Upstream says it's up to distributions to add a way to support local-magic.
Patch0: file-localmagic.patch
# sent upstream - should be included in next upstream release
Patch1: file-tnef.patch
Patch2: file-5.10-strength.patch
Patch3: file-5.10-sticky-bit.patch
Patch4: file-python-func.patch
Patch5: file-qed-vdi-image.patch
Patch6: file-5.11-ia64-swap.patch
Patch7: file-4.17-rpm-name.patch
Patch8: file-5.11-magicmgc-home.patch
Patch9: file-5.11-compress.patch
Patch10: file-5.11-dump-twice.patch
Patch11: file-5.04-volume_key.patch
Patch12: file-5.04-man-return-code.patch
Patch13: file-5.04-generic-msdos.patch
Patch14: file-5.14-netpbm.patch
Patch15: file-5.14-journald.patch
Patch16: file-5.11-CVE-2014-1943.patch
Patch17: file-5.11-CVE-2014-2270.patch

Patch104604: bug-104604-detect-qcow2-version-correctly.patch

URL: http://www.darwinsys.com/file/
Requires: file-libs = %{version}-%{release}
BuildRequires: zlib-devel

%description
The file command is used to identify a particular file according to the
type of data contained by the file.  File can identify many different
file types, including ELF binaries, system libraries, RPM packages, and
different graphics formats.

%package libs
Summary: Libraries for applications using libmagic
Group:   Applications/File
License: BSD

%description libs

Libraries for applications using libmagic.

%package devel
Summary:  Libraries and header files for file development
Group:    Applications/File
Requires: %{name} = %{version}-%{release}

%description devel
The file-devel package contains the header files and libmagic library
necessary for developing programs using libmagic.

%package static
Summary: Static library for file development
Group:    Applications/File
Requires: %{name} = %{version}-%{release}

%description static
The file-static package contains the static version of
the libmagic library.

%if 0%{?with_python}
%package -n python-magic
Summary: Python bindings for the libmagic API
Group:   Development/Libraries
BuildArch: noarch
BuildRequires: python2-devel
Requires: %{name} = %{version}-%{release}

%description -n python-magic
This package contains the Python bindings to allow access to the
libmagic API. The libmagic library is also used by the familiar
file(1) command.
%endif # with_python

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep

# Don't use -b -- it will lead to poblems when compiling magic file!
%setup -q -a 999
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1

%patch104604 -p1

iconv -f iso-8859-1 -t utf-8 < doc/libmagic.man > doc/libmagic.man_
touch -r doc/libmagic.man doc/libmagic.man_
mv doc/libmagic.man_ doc/libmagic.man

%build
CFLAGS="%{optflags} -D_GNU_SOURCE -D_FILE_OFFSET_BITS=64 -D_LARGEFILE_SOURCE" \
%configure --enable-fsect-man5 --disable-rpath
# remove hardcoded library paths from local libtool
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
# bug 71097: the buildsys /usr/bin/file needs to be able to find it's libmagic.so
%if ! 0%{?cross_build}
export LD_LIBRARY_PATH=%{_builddir}/%{name}-%{version}/src/.libs
%endif
make
%if 0%{?with_python}
cd python
CFLAGS="%{optflags}" %{__python} setup.py build
cd ..
%endif # with_python

pushd fivextra
make all
popd

%install
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man1
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man5
mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/misc
mkdir -p ${RPM_BUILD_ROOT}%{_datadir}/file

make DESTDIR=${RPM_BUILD_ROOT} install
rm -f ${RPM_BUILD_ROOT}%{_libdir}/*.la

# local magic in /etc/magic
mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}
cp -a ./magic/magic.local ${RPM_BUILD_ROOT}%{_sysconfdir}/magic

cat magic/Magdir/* > ${RPM_BUILD_ROOT}%{_datadir}/misc/magic
ln -s misc/magic ${RPM_BUILD_ROOT}%{_datadir}/magic
#ln -s file/magic.mime ${RPM_BUILD_ROOT}%{_datadir}/magic.mime
ln -s ../magic ${RPM_BUILD_ROOT}%{_datadir}/file/magic

# Steps to package the file tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%if 0%{?with_python}
cd python
%{__python} setup.py install -O1 --skip-build --root ${RPM_BUILD_ROOT}
%{__install} -d ${RPM_BUILD_ROOT}%{_datadir}/%{name}
%endif # with_python

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%files
%doc COPYING ChangeLog README
%{_bindir}/*
%{_mandir}/man1/*
%config(noreplace) %{_sysconfdir}/magic

%files libs
%doc COPYING ChangeLog README
%{_libdir}/*so.*
%{_datadir}/magic*
%{_mandir}/man5/*
%{_datadir}/file
%{_datadir}/misc/*

%files devel
%{_libdir}/*.so
%{_includedir}/magic.h
%{_mandir}/man3/*

%files static
%{_libdir}/*.a

%if 0%{?with_python}
%files -n python-magic
%doc python/README COPYING python/example.py
%{python_sitelib}/magic.py
%{python_sitelib}/magic.pyc
%{python_sitelib}/magic.pyo
%if 0%{?fedora} >= 9 || 0%{?rhel} >= 6
%{python_sitelib}/*egg-info
%endif
%endif # with_python

%files fivextra
%{prefix}

%changelog
* Tue Jun 17 2014 baseuser@ibm.com
- Base-f19.x spec file
