# if 0%{?fedora} >= 13
# global with_python3 1
# else
# if 0%{?rhel} >= 7
# global with_python3 1
# endif
# endif

%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

Name:           python-httplib2
Version:        0.7.7
%define base_release .2
Release:        2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        A comprehensive HTTP client library
Group:          System Environment/Libraries
License:        MIT
URL:            http://code.google.com/p/httplib2/
Source0:        http://httplib2.googlecode.com/files/httplib2-%{version}.tar.gz
#Patch0:         httplib_py26.diff
Patch1:         %{name}.certfile.patch
Patch2:         %{name}.getCertHost.patch
Patch3:         %{name}.rfc2459.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:  python-setuptools-devel
BuildRequires:  python-devel
BuildArch:      noarch

%if 0%{?with_python3}
BuildRequires:  python3-devel
%endif # if with_python3

%description
A comprehensive HTTP client library that supports many features left out of
other HTTP libraries.

%if 0%{?with_python3}
%package -n python3-httplib2
Summary:        A comprehensive HTTP client library
Group:          System Environment/Libraries

%description -n python3-httplib2
A comprehensive HTTP client library that supports many features left out of
other HTTP libraries.
%endif # with_python3

%prep
%setup -q -n httplib2-%{version}
#%patch0 -p0 -b .issue39
%patch1 -p0 -b .certfile
%patch2 -p0 -b .getCertHost
%patch3 -p0 -b .rfc2459

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
find %{py3dir} -name '*.py' | xargs sed -i '1s|^#!/usr/bin/python|#!%{__python3}|'
%endif # with_python3

%build
CFLAGS="$RPM_OPT_FLAGS" %{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3

%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root $RPM_BUILD_ROOT
popd
%endif # with_python3

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc README
%{python_sitelib}/*

%if 0%{?with_python3}
%files -n python3-httplib2
%defattr(-,root,root,-)
%doc README
%{python3_sitelib}/*
%endif # with_python3

%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
