%define _sbindir /sbin
%define _libdir /%{_lib}

Summary: The GNU disk partition manipulation program
Name:    parted
Version: 3.1
%define base_release .4
Release: 12%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv3+
Group:   Applications/System
URL:     http://www.gnu.org/software/parted

Source0: ftp://ftp.gnu.org/gnu/%{name}/%{name}-%{version}.tar.xz
Source1: ftp://ftp.gnu.org/gnu/%{name}/%{name}-%{version}.tar.xz.sig
Source2: pubkey.jim.meyering
Source999: fivextra.tar.bz2

Patch0: parted-3.0-libparted-copy-pmbr_boot-when-duplicating-GPT-disk.patch
Patch1: parted-3.1-libparted-check-PMBR-before-GPT-partition-table-8052.patch
Patch2: parted-3.1-tests-add-t0301-overwrite-gpt-pmbr.sh.patch
Patch3: parted-3.1-libparted-Fix-endian-error-with-FirstUsableLBA.patch
Patch4: parted-2.1-libparted-use-dm_udev_wait-698121.patch
Patch5: parted-3.1-libparted-use-largest_partnum-in-dm_reread_part_tabl.patch
patch6: parted-3.1-test-creating-20-device-mapper-partitions.patch
Patch7: parted-3.1-libparted-preserve-the-uuid-on-dm-partitions.patch
Patch8: parted-3.1-tests-Make-sure-dm-UUIDs-are-not-erased.patch
Patch9: parted-3.1-libparted-reallocate-buf-after-_disk_analyse_block_s.patch
Patch10: parted-3.1-tests-cleanup-losetup-usage.patch
Patch11: parted-3.1-libparted-add-support-for-implicit-FBA-DASD-partitions.patch
Patch12: parted-3.1-libparted-add-support-for-EAV-DASD-partitions.patch
Patch13: parted-3.1-libparted-don-t-canonicalize-dev-md-paths.patch
Patch14: parted-3.1-libparted-mklabel-eav.patch
Patch15: parted-3.1-avoid-dasd-as-default-file-image-type.patch
Patch16: parted-3.1-libparted-mklabel-edev.patch
Patch17: parted-3.1-tests-rewrite-t6001-to-use-dev-mapper.patch


Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: e2fsprogs-devel
BuildRequires: readline-devel
BuildRequires: ncurses-devel
BuildRequires: gettext-devel
BuildRequires: texinfo
BuildRequires: device-mapper-devel
BuildRequires: libselinux-devel
BuildRequires: libuuid-devel
BuildRequires: libblkid-devel >= 2.17
BuildRequires: gnupg
BuildRequires: git
BuildRequires: autoconf automake
BuildRequires: e2fsprogs
BuildRequires: dosfstools

Requires(post): /sbin/ldconfig
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Requires(postun): /sbin/ldconfig

# bundled gnulib library exception, as per packaging guidelines
# https://fedoraproject.org/wiki/Packaging:No_Bundled_Libraries
Provides: bundled(gnulib)

%description
The GNU Parted program allows you to create, destroy, resize, move,
and copy hard disk partitions. Parted can be used for creating space
for new operating systems, reorganizing disk usage, and copying data
to new hard disks.


%package devel
Summary:  Files for developing apps which will manipulate disk partitions
Group:    Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
The GNU Parted library is a set of routines for hard disk partition
manipulation. If you want to develop programs that manipulate disk
partitions and filesystems using the routines provided by the GNU
Parted library, you need to install this package.


%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999 
gpg --import %{SOURCE2}
gpg --verify %{SOURCE1} %{SOURCE0}
git init
git config user.email "parted-owner@fedoraproject.org"
git config user.name "Fedora Ninjas"
git add .
git commit -a -q -m "%{version} baseline."
git am %{patches}
iconv -f ISO-8859-1 -t UTF8 AUTHORS > tmp; touch -r AUTHORS tmp; mv tmp AUTHORS
git commit -a -m "run iconv"
# And also clean up
rm -rf .git

%build
autoreconf
autoconf
CFLAGS="$RPM_OPT_FLAGS -Wno-unused-but-set-variable"; export CFLAGS
%configure --enable-selinux --disable-static
# Don't use rpath!
%{__sed} -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
%{__sed} -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
V=1 %{__make} %{?_smp_mflags}


## Build tests in sources
pushd tests
make print-align print-max duplicate dup-clobber
popd 

%install
%{__rm} -rf %{buildroot}
%{__make} install DESTDIR=%{buildroot}

# Move devel package components in to the correct location
%{__mkdir} -p %{buildroot}%{_exec_prefix}/%{_lib}
%{__mv} %{buildroot}%{_libdir}/libparted.so %{buildroot}%{_exec_prefix}/%{_lib}
%{__mv} %{buildroot}%{_libdir}/pkgconfig %{buildroot}%{_exec_prefix}/%{_lib}
pushd %{buildroot}%{_exec_prefix}/%{_lib}
reallibrary="$(readlink libparted.so)"
%{__rm} -f libparted.so
ln -sf ../../%{_lib}/${reallibrary} libparted.so
popd

# Remove components we do not ship
%{__rm} -rf %{buildroot}%{_libdir}/*.la
%{__rm} -rf %{buildroot}%{_infodir}/dir
%{__rm} -rf %{buildroot}%{_bindir}/label
%{__rm} -rf %{buildroot}%{_bindir}/disk

%find_lang %{name}


# Steps to package the parted tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/build-aux
install build-aux/mktempd $RPM_BUILD_ROOT%{fivdir}/%{name}/build-aux/
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/lib
install lib/config.h $RPM_BUILD_ROOT%{fivdir}/%{name}/lib
for dir in $(find tests -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir || true
done
install tests/.libs/print-max $RPM_BUILD_ROOT%{fivdir}/%{name}/tests
install tests/.libs/print-align $RPM_BUILD_ROOT%{fivdir}/%{name}/tests
install tests/.libs/duplicate $RPM_BUILD_ROOT%{fivdir}/%{name}/tests

find $RPM_BUILD_ROOT/%{fivdir}/%{name}/ -maxdepth 2 -name *.o | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 

%check
export LD_LIBRARY_PATH=$(pwd)/libparted/.libs
make check


%clean
%{__rm} -rf %{buildroot}


%post
/sbin/ldconfig
if [ -f %{_infodir}/parted.info.gz ]; then
    /sbin/install-info %{_infodir}/parted.info.gz %{_infodir}/dir || :
fi

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/parted.info.gz %{_infodir}/dir >/dev/null 2>&1 || :
fi

%postun -p /sbin/ldconfig


%files -f %{name}.lang
%defattr(-,root,root,-)
%doc AUTHORS BUGS COPYING ChangeLog NEWS README THANKS TODO doc/API doc/FAT
%{_sbindir}/parted
%{_sbindir}/partprobe
%{_mandir}/man8/parted.8.gz
%{_mandir}/man8/partprobe.8.gz
%{_libdir}/libparted.so.*
%{_libdir}/libparted-fs-resize.so*
%{_infodir}/parted.info.gz

%files devel
%defattr(-,root,root,-)
%{_includedir}/parted
%{_exec_prefix}/%{_lib}/libparted.so
%{_exec_prefix}/%{_lib}/pkgconfig/libparted.pc


%files fivextra
%{prefix} 

%changelog
* Sat Jun 01 2013 baseuser@ibm.com
- Base-8.x spec file
