# if !(0%{?rhel} >= 6 || 0%{?fedora} >= 13)
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
# endif

Name:           python-configobj
Version:        4.7.2
%define base_release .2
Release:        6%{?dist}%{?base_release}
Summary:        Config file reading, writing, and validation

Group:          System Environment/Libraries
License:        BSD
URL:            http://www.voidspace.org.uk/python/configobj.html
Source0:        http://www.voidspace.org.uk/downloads/configobj-%{version}.zip
Patch0:         configobj-import-all-fix.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

BuildRequires: python-devel

%description
ConfigObj is a simple but powerful config file reader and writer: an ini file
round tripper. Its main feature is that it is very easy to use, with a
straightforward programmer's interface and a simple syntax for config files. 
It has lots of other features though:
    * Nested sections (subsections), to any level
    * List values
    * Multiple line values
    * String interpolation (substitution)
    * Integrated with a powerful validation system
          o including automatic type checking/conversion
          o repeated sections
          o and allowing default values
    * All comments in the file are preserved
    * The order of keys/sections is preserved
    * No external dependencies
    * Full Unicode support
    * A powerful unrepr mode for storing basic datatypes


%prep
%setup -q -n configobj-%{version}
%patch0 -p1 -b .all

%build
%{__python} setup.py build


%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install --skip-build --root=$RPM_BUILD_ROOT

%check
export PYTHONPATH="%{buildroot}/%{python_sitelib}"
%{__python} tests/test_configobj.py

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc docs/*
%{python_sitelib}/*

%changelog
* Tue Dec 17 2013 baseuser@ibm.com
- Base-8.x spec file
