Name: libusb
Epoch: 1
Version: 0.1.4
%define base_release .3
Release: 1%{?dist}%{?base_release}
Summary: A library which allows userspace access to USB devices
Group: System Environment/Libraries
License: LGPLv2+
URL: http://sourceforge.net/projects/libusb/
Source0: http://downloads.sourceforge.net/libusb/libusb-compat-%{version}.tar.bz2
Source999: fivextra.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Patch0: libusb-config-multilib.patch

BuildRequires: libusb1-devel

%description
This package provides a way for applications to access USB devices.
Legacy libusb-0.1 is no longer supported by upstream, therefore content of this
package was replaced by libusb-compat. It provides compatibility layer allowing
applications written for libusb-0.1 to work with libusb-1.0.

%package devel
Summary: Development files for libusb
Group: Development/Libraries
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: pkgconfig

%description devel
This package contains the header files, libraries and documentation needed to
develop applications that use libusb-0.1. However new applications should use
libusb-1.0 library instead of this one.

%package static
Summary: Static development files for libusb
Group: Development/Libraries
Requires: %{name}-devel = %{epoch}:%{version}-%{release}

%description static
This package contains static libraries needed to develop applications that use
libusb-0.1. However new applications should use libusb-1.0 library instead of
this one.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n libusb-compat-%{version} -a 999
%patch0 -p1 -b .config-multilib

%build
%configure --libdir=/%{_lib}
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}
rm -f %{buildroot}/%{_lib}/libusb.la

mkdir -p %{buildroot}%{_libdir}/pkgconfig
mv %{buildroot}/%{_lib}/pkgconfig/* %{buildroot}%{_libdir}/pkgconfig/

# Steps to package the libusb tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 2 \
-name 'Makefile*' -o -name '*.c' | xargs rm -rf 

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
/%{_lib}/libusb-0.1.so.*

%files devel
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README
%{_includedir}/usb.h
/%{_lib}/libusb.so
%{_libdir}/pkgconfig/libusb.pc
%{_bindir}/libusb-config

%files static
%defattr(-,root,root,-)
/%{_lib}/libusb.a

%files fivextra
%{prefix}

%changelog
* Thu May 16 2013 baseuser@ibm.com
- Base-8.x spec file
