Name: libdaemon
Version: 0.14
%define base_release .2
Release: 5%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary: Library for writing UNIX daemons
Group: System Environment/Libraries
License: LGPLv2+
URL: http://0pointer.de/lennart/projects/libdaemon/
Source0: http://0pointer.de/lennart/projects/libdaemon/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2

# Requires lynx to build the docs
BuildRequires:  lynx

%description
libdaemon is a lightweight C library which eases the writing of UNIX daemons.
It consists of the following parts:
* A wrapper around fork() which does the correct daemonization
  procedure of a process
* A wrapper around syslog() for simpler and compatible log output to
  Syslog or STDERR
* An API for writing PID files
* An API for serializing UNIX signals into a pipe for usage with
  select() or poll()
* An API for running subprocesses with STDOUT and STDERR redirected
  to syslog.

%package devel
Group: Development/Libraries
Summary: Libraries and header files for libdaemon development
Requires: libdaemon = %{version}-%{release}

%description devel
The libdaemon-devel package contains the header files and libraries
necessary for developing programs using libdaemon.

%package fivextra
Summary: libdaemon functional tests
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
libdaemon tests

%prep
%setup -q -a 999

%build
%configure --disable-static
make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
find $RPM_BUILD_ROOT \( -name *.a -o -name *.la \) -exec rm {} \;

rm $RPM_BUILD_ROOT/%{_datadir}/doc/libdaemon/README
rm $RPM_BUILD_ROOT/%{_datadir}/doc/libdaemon/README.html
rm $RPM_BUILD_ROOT/%{_datadir}/doc/libdaemon/style.css

#Steps to package the libdaemon tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
 install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

tdir=$RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
[ ! -d $tdir ] && install -d -m 755 $tdir
install -m 755 examples/.libs/test* $tdir
install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc LICENSE README
%{_libdir}/*so.*

%files devel
%defattr(-,root,root,-)
%doc doc/README.html doc/style.css
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc

%files fivextra
%{prefix}

%changelog
* Mon May 20 2013 baseuser@ibm.com
- Base-8.x spec file
