# Fakeroot only: this package is useful for development in fakeroots. It is not
# available as a base package, though it may be delivered with an approved PCR.
# We redefine base dist here to help this package stand out as fakeroot-only.
%{lua:
  curdist = rpm.expand("%{?dist}")
  if string.sub(curdist, 1, 4) == ".f19" then
    frootdist = string.gsub(curdist, "f19", "froot19")
    rpm.define("dist "..frootdist)
  end
}

Name:		scrub
Version:	2.5.2
%define base_release .2
Release:	3%{?dist}%{?base_release}
Summary:	Disk scrubbing program
License:	GPLv2+
Group:		System Environment/Base
URL:		http://code.google.com/p/diskscrub/
Source0:	http://diskscrub.googlecode.com/files/%{name}-%{version}.tar.bz2

%description
Scrub writes patterns on files or disk devices to make
retrieving the data more difficult.  It operates in one of three
modes: 1) the special file corresponding to an entire disk is scrubbed
and all data on it is destroyed;  2) a regular file is scrubbed and
only the data in the file (and optionally its name in the directory
entry) is destroyed; or 3) a regular file is created, expanded until
the file system is full, then scrubbed as in 2).

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
make DESTDIR=%{buildroot} install

%files
%doc DISCLAIMER COPYING
%doc README ChangeLog
%{_bindir}/scrub
%{_mandir}/man1/scrub.1*

%changelog
* Tue Jun 11 2013 baseuser@ibm.com
- Base-8.x spec file
