# Base will disable oniguruma for now
%if 0%{?fedora:1} && ! 0%{?base:1}
%bcond_without oniguruma
%else
%bcond_with oniguruma
%endif
Summary: The shared library for the S-Lang extension language
Name: slang
Version: 2.2.4
%define base_release .4
Release: 8%{?dist}%{?base_release}
License: GPLv2+
Group: System Environment/Libraries
Source: ftp://space.mit.edu/pub/davis/slang/v2.2/%{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2
# fix file permissions
Patch1: slang-2.2.4-perms.patch
URL: http://www.jedsoft.org/slang/
BuildRequires: libpng-devel pcre-devel zlib-devel
%if ! 0%{?cross_build}
%if %{with oniguruma}
BuildRequires: oniguruma-devel
%endif
%endif

%description
S-Lang is an interpreted language and a programming library.  The
S-Lang language was designed so that it can be easily embedded into
a program to provide the program with a powerful extension language.
The S-Lang library, provided in this package, provides the S-Lang
extension language.  S-Lang's syntax resembles C, which makes it easy
to recode S-Lang procedures in C if you need to.

%package slsh
Summary: Interpreter for S-Lang scripts
Group: Development/Languages
Requires: %{name} = %{version}-%{release}

%description slsh
slsh (slang-shell) is a program for interpreting S-Lang scripts. 
It supports dynamic loading of S-Lang modules and includes a readline
interface for interactive use.

This package also includes S-Lang modules that are distributed with
the S-Lang distribution.

%package devel
Summary: Development files for the S-Lang extension language
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
This package contains files which you'll need if you want to
develop S-Lang based applications.  Documentation which may help
you write S-Lang based applications is also included.

Install the slang-devel package if you want to develop applications
based on the S-Lang extension language.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%package static
Summary: The static library for the S-Lang extension language
Group: Development/Libraries
Requires: %{name}-devel = %{version}-%{release}

%description static
This package includes static library for the S-Lang extension
language.

%prep
%setup -q
%setup -q -a 999
%patch1 -p1 -b .perms

head -n -1800 < changes.txt > changes.txt_ && tail -n 1800 < changes.txt | \
	iconv -f iso8859-1 -t utf8 >> changes.txt_ && \
	touch -r changes.txt{,_} && mv changes.txt{_,}

%build
%configure \
	--with-{pcre,png,z}lib=%{_libdir} \
	--with-{pcre,png,z}inc=%{_includedir} \
%if %{with oniguruma}
       %{!?cross_build: --with-oniglib=%{_libdir}} \
       %{!?cross_build: --with-oniginc=%{_includedir}} \
%endif
;

# fails with %{?_smp_mflags}
make RPATH="" install_doc_dir=%{_docdir}/%{name}-%{version}

make check || true

%install
make install-all INSTALL="install -p" RPATH="" DESTDIR=$RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT%{_docdir}/{slang,slsh}

mkdir $RPM_BUILD_ROOT%{_includedir}/slang
for h in slang.h slcurses.h; do
	ln -s ../$h $RPM_BUILD_ROOT%{_includedir}/slang/$h
done
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done
pushd src
for dir in $(find test -type d ) 
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done
popd
find $RPM_BUILD_ROOT/%{fivdir}/%{name}/test -name Makefile -o -name sltest.c | xargs rm -f
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/doc/text
install doc/text/slangfun.txt $RPM_BUILD_ROOT%{fivdir}/%{name}/doc/text/
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/slsh/lib
install slsh/lib/require.sl $RPM_BUILD_ROOT%{fivdir}/%{name}/slsh/lib

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd 

%clean
rm -rf ${RPM_BUILD_ROOT}


%check
make check

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc COPYING NEWS doc/README changes.txt doc/*/slang*.txt doc/*.txt
%{_libdir}/libslang*.so.*

%files slsh
%doc slsh/doc/html/slsh*.html
%config(noreplace) %{_sysconfdir}/slsh.rc
%{_bindir}/slsh
%{_libdir}/slang
%{_mandir}/man1/slsh.1*
%{_datadir}/slsh

%files devel
%doc doc/*/cslang*.txt doc/*/cref.txt
%{_libdir}/libslang*.so
%{_libdir}/pkgconfig/slang.pc
%{_includedir}/sl*.h
%{_includedir}/slang

%files static
%{_libdir}/libslang*.a

%files fivextra
%{prefix}

%changelog
* Tue May 14 2013 baseuser@ibm.com
- Base-8.x spec file
