# -*- rpm-spec -*-


%define with_guestfs               0
%define stable_defaults            0
%define askpass_package            "openssh-askpass"
%define qemu_user                  "qemu"
%define libvirt_packages           "libvirt-daemon-kvm,libvirt-daemon-config-network"
%define preferred_distros          "fedora,rhel"
%define kvm_packages               "qemu-system-x86"

%if 0%{?rhel} || 0%{?base}
%define preferred_distros          "rhel,fedora"
%define kvm_packages               "qemu-kvm"
%define stable_defaults            1
%endif


# End local config

%define _version 1.0.1
%define _release 1


# This macro is used for the continuous automated builds. It just
# allows an extra fragment based on the timestamp to be appended
# to the release. This distinguishes automated builds, from formal
# Fedora RPM builds
%define _extra_release %{?dist:%{dist}}%{?extra_release:%{extra_release}}

Name: virt-manager
Version: %{_version}
%define base_release .3
Release: %{_release}%{_extra_release}%{?base_release}
%define verrel %{version}-%{release}
ExcludeArch: mips64 ppca2 ppc476 ppcnf

Summary: Virtual Machine Manager
Group: Applications/Emulators
License: GPLv2+
URL: http://virt-manager.org/
Source0: http://virt-manager.org/download/sources/%{name}/%{name}-%{version}.tar.gz
BuildArch: noarch

#Source0: http://virt-manager.org/download/sources/%{name}/%{name}-%{version}.tar.gz
# Generate source with
#   git clone git://git.fedorahosted.org/git/virt-manager.git
#   cd virt-manager
#   git archive --output virt-manager-%{gitcommit}.tar.gz --prefix virt-manager-%{gitcommit}/ %{gitcommit}

Requires: virt-manager-common = %{verrel}
Requires: pygobject3
Requires: gtk3
Requires: libvirt-glib >= 0.0.9
#Requires: gnome-python2-gconf
Requires: libxml2-python
Requires: vte3
Requires: dconf
Requires: dbus-x11


# For console widget
Requires: gtk-vnc2
Requires: spice-gtk3


#%if %{with_guestfs}
#Requires: python-libguestfs
#%endif


BuildRequires: intltool
BuildRequires: /usr/bin/pod2man


%description
Virtual Machine Manager provides a graphical tool for administering virtual
machines for KVM, Xen, and LXC. Start, stop, add or remove virtual devices,
connect to a graphical or serial console, and see resource usage statistics
for existing VMs on local or remote machines. Uses libvirt as the backend
management API.


%package common
Summary: Common files used by the different Virtual Machine Manager interfaces
Group: Applications/Emulators

# This version not strictly required: virt-manager should work with older,
# however varying amounts of functionality will not be enabled.
Requires: libvirt-python >= 0.7.0
Requires: libxml2-python
Requires: python-urlgrabber
Requires: python-ipaddr

%description common
Common files used by the different virt-manager interfaces, as well as
virt-install related tools.


%package -n virt-install
Summary: Utilities for installing virtual machines

Requires: virt-manager-common = %{verrel}

Provides: virt-install
Provides: virt-clone
Provides: virt-image
Provides: virt-convert
Provides: virt-xml
Obsoletes: python-virtinst

%description -n virt-install
Package includes several command line utilities, including virt-install
(build and install new VMs) and virt-clone (clone an existing virtual
machine).


%prep
%setup -q

%build
%if %{qemu_user}
%define _qemu_user --qemu-user=%{qemu_user}
%endif

%if %{kvm_packages}
%define _kvm_packages --kvm-package-names=%{kvm_packages}
%endif

%if %{preferred_distros}
%define _preferred_distros --preferred-distros=%{preferred_distros}
%endif

%if %{libvirt_packages}
%define _libvirt_packages --libvirt-package-names=%{libvirt_packages}
%endif

%if %{askpass_package}
%define _askpass_package --askpass-package-names=%{askpass_package}
%endif

%if %{stable_defaults}
%define _stable_defaults --stable-defaults
%endif

#%if 0%{?default_graphics:1}
#%define _default_graphics --default-graphics=%{default_graphics}
#%endif


python setup.py configure \
    --pkgversion="%{version}" \
    %{?_qemu_user} \
    %{?_kvm_packages} \
    %{?_libvirt_packages} \
    %{?_askpass_package} \
    %{?_preferred_distros} \
    %{?_stable_defaults}


%install
python setup.py install -O1 --root=$RPM_BUILD_ROOT

%find_lang %{name}


%post
/bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null || :
/usr/bin/update-desktop-database &> /dev/null || :


%postun
if [ $1 -eq 0 ] ; then
    /bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null
    /usr/bin/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
    /usr/bin/glib-compile-schemas %{_datadir}/glib-2.0/schemas &> /dev/null || :
fi
/usr/bin/update-desktop-database &> /dev/null || :


%posttrans
/usr/bin/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
/usr/bin/glib-compile-schemas %{_datadir}/glib-2.0/schemas &> /dev/null || :


%files
%doc README COPYING NEWS
%{_bindir}/%{name}

%{_mandir}/man1/%{name}.1*

%{_datadir}/%{name}/ui/*.ui
%{_datadir}/%{name}/virt-manager
%{_datadir}/%{name}/virtManager

%{_datadir}/%{name}/icons
%{_datadir}/icons/hicolor/*/apps/*

%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/glib-2.0/schemas/org.virt-manager.virt-manager.gschema.xml


%files common -f %{name}.lang
%dir %{_datadir}/%{name}

%{_datadir}/%{name}/virtcli
%{_datadir}/%{name}/virtconv
%{_datadir}/%{name}/virtinst


%files -n virt-install
%{_mandir}/man1/virt-install.1*
%{_mandir}/man1/virt-clone.1*
%{_mandir}/man1/virt-convert.1*
%{_mandir}/man1/virt-xml.1*
%{_mandir}/man1/virt-image.1*
%{_mandir}/man5/virt-image.5*

%{_datadir}/%{name}/virt-install
%{_datadir}/%{name}/virt-clone
%{_datadir}/%{name}/virt-image
%{_datadir}/%{name}/virt-convert
%{_datadir}/%{name}/virt-xml

%{_bindir}/virt-install
%{_bindir}/virt-clone
%{_bindir}/virt-image
%{_bindir}/virt-convert
%{_bindir}/virt-xml

%changelog
* Thu Jul 11 2013 baseuser@ibm.com
- Base-8.x spec file
