Name:           rpcbind
Version:        0.2.1
%define base_release .2
Release:        0.2%{?dist}%{?base_release}
Summary:        Universal Addresses to RPC Program Number Mapper
Group:          System Environment/Daemons
License:        BSD
URL:            http://nfsv4.bullopensource.org

BuildRoot:      %{_tmppath}/%{name}-%{version}-root-%(%{__id_u} -n)
Source0:        http://downloads.sourceforge.net/rpcbind/%{name}-%{version}.tar.bz2
Source1: rpcbind.service
Source2: rpcbind.socket
Source3: rpcbind.sysconfig
Source999: fivextra.tar.bz2

Requires: glibc-common setup
Conflicts: man-pages < 2.43-12
BuildRequires: automake, autoconf, libtool, systemd-units
BuildRequires: libtirpc-devel, quota-devel, tcp_wrappers-devel
Requires(pre): coreutils shadow-utils
Requires(post): chkconfig systemd-units systemd-sysv
Requires(preun): systemd-units
Requires(postun): systemd-units coreutils

Provides: portmap = %{version}-%{release}
Obsoletes: portmap <= 4.0-65.3

Patch001: rpcbind-0.2.1-rpcuser.patch

%description
The rpcbind utility is a server that converts RPC program numbers into
universal addresses.  It must be running on the host to be able to make
RPC calls on a server on that machine.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%patch001 -p1

%build
%ifarch s390 s390x
PIE="-fPIE"
%else
PIE="-fpie"
%endif
export PIE

RPCBUSR=rpc
RPCBDIR=/var/lib/rpcbind
CFLAGS="`echo $RPM_OPT_FLAGS $ARCH_OPT_FLAGS $PIE`"

autoreconf -fisv
%configure CFLAGS="$CFLAGS" LDFLAGS="-pie" \
    --enable-warmstarts \
    --with-statedir="$RPCBDIR" \
    --with-rpcuser="$RPCBUSR" \
    --enable-libwrap \
    --enable-debug

make all

# Build tests for fivextra
pushd fivextra
make all
popd

%install
rm -rf %{buildroot}
mkdir -p %{buildroot}{/sbin,/usr/sbin,/etc/sysconfig}
mkdir -p %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_mandir}/man8
mkdir -p %{buildroot}/var/lib/rpcbind
make DESTDIR=$RPM_BUILD_ROOT install

mv -f ${RPM_BUILD_ROOT}%{_bindir}/rpcbind ${RPM_BUILD_ROOT}/sbin
mv -f ${RPM_BUILD_ROOT}%{_bindir}/rpcinfo ${RPM_BUILD_ROOT}%{_sbindir}
install -m644 %{SOURCE1} %{buildroot}%{_unitdir}
install -m644 %{SOURCE2} %{buildroot}%{_unitdir}
install -m644 %{SOURCE3} %{buildroot}/etc/sysconfig/rpcbind

# Steps to package the rpcbind tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf %{buildroot}

%pre

# Check the validity of the rpc uid and gid.
# If they don't exist, create them
# If they exist but are the wrong value, remove them 
#   and recreate them with the correct value
# If they exist and are the correct value do nothing
rpcid=`getent passwd rpc | cut -d: -f 3`
if [ -n "$rpcid" -a "$rpcid" != "32" ]; then
	/usr/sbin/userdel  rpc 2> /dev/null || :
	/usr/sbin/groupdel rpc 2> /dev/null || : 
fi
if [ -z "$rpcid" -o "$rpcid" != "32" ]; then
	/usr/sbin/groupadd -o -g 32 rpc > /dev/null 2>&1
	/usr/sbin/useradd -o -l -c "Rpcbind Daemon" -d /var/lib/rpcbind -g 32 \
    	-M -s /sbin/nologin -u 32 rpc > /dev/null 2>&1
fi
%post
if [ $1 -eq 1 ] ; then 
    # Initial installation
    /bin/systemctl enable rpcbind.service >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ]; then
	# Package removal, not upgrade
	/bin/systemctl --no-reload disable rpcbind.service >/dev/null 2>&1 || :
	/bin/systemctl stop rpcbind.service >/dev/null 2>&1 || :
	/usr/sbin/userdel  rpc 2>/dev/null || :
	/usr/sbin/groupdel rpc 2>/dev/null || :
	rm -rf /var/lib/rpcbind
fi

%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ]; then
	# Package upgrade, not uninstall
	/bin/systemctl try-restart rpcbind.service >/dev/null 2>&1 || :
fi

%triggerun -- rpcbind < 0.2.0-15
%{_bindir}/systemd-sysv-convert --save rpcbind >/dev/null 2>&1 ||:
/bin/systemctl --no-reload enable rpcbind.service >/dev/null 2>&1
/sbin/chkconfig --del rpcbind >/dev/null 2>&1 || :
/bin/systemctl try-restart rpcbind.service >/dev/null 2>&1 || :

%files
%defattr(-,root,root)
%config(noreplace) /etc/sysconfig/rpcbind
%doc AUTHORS ChangeLog README
/sbin/rpcbind
%{_sbindir}/rpcinfo
%{_mandir}/man8/*
%{_unitdir}/rpcbind.service
%{_unitdir}/rpcbind.socket

%dir %attr(700,rpc,rpc) /var/lib/rpcbind

%files fivextra
%{prefix}

%changelog
* Thu Jan 23 2014 baseuser@ibm.com
- Base-f19.x spec file
