%{?!WITH_DOC: %define WITH_DOC 0}
%global             cbq_version v0.7.3
Summary:            Advanced IP routing and network device configuration tools
Name:               iproute
Version:            3.9.0
%define base_release .5
Release:            1%{?dist}%{?base_release}
Group:              Applications/System
URL:                http://kernel.org/pub/linux/utils/net/%{name}2/
Source0:            http://kernel.org/pub/linux/utils/net/%{name}2/%{name}2-%{version}.tar.gz
Source1:            cbq-0000.example
Source2:            avpkt
Source999:          fivextra.tar.bz2
Patch0:             man-pages.patch
Patch1:             iproute2-3.4.0-kernel.patch
Patch2:             iproute2-3.8.0-optflags.patch
Patch3:             iproute2-3.4.0-sharepath.patch
Patch4:             iproute2-3.9.0-IPPROTO_IP_for_SA.patch
Patch5:             iproute2-example-cbq-service.patch
Patch6:             iproute2-2.6.35-print-route.patch
Patch7:             iproute2-2.6.39-create-peer-veth-without-a-name.patch
Patch8:             iproute2-2.6.39-lnstat-dump-to-stdout.patch
Patch9:             iproute2-3.8.0-unused-result.patch
Patch10:	    iproute2-3.9.0-sigabrt-xfrm-state.patch

Patch104635:            bug-104635-close-file-with-bridge-monitor-file.patch

License:            GPLv2+ and Public Domain
BuildRequires:      bison
BuildRequires:      flex
BuildRequires:      iptables-devel >= 1.4.5
BuildRequires:      libdb-devel
BuildRequires:      libnl-devel
#BuildRequires:      linuxdoc-tools
BuildRequires:      pkgconfig
BuildRequires:      psutils
#BuildRequires:      tex(cm-super-t1.enc)
#BuildRequires:      tex(dvips)
#BuildRequires:      tex(ecrm1000.tfm)
#BuildRequires:      tex(latex)
# if 0%{?fedora}
# BuildRequires:      linux-atm-libs-devel
# endif
# For the UsrMove transition period
Conflicts:          filesystem < 3
Provides:           /sbin/ip

%description
The iproute package contains networking utilities (ip and rtmon, for example)
which are designed to use the advanced networking capabilities of the Linux
2.4.x and 2.6.x kernel.

%if %{WITH_DOC}
%package doc
Summary:            ip and tc documentation with examples
Group:              Applications/System
License:            GPLv2+

%description doc
The iproute documentation contains howtos and examples of settings.
%endif

%package devel
Summary:            iproute development files
Group:              Development/Libraries
License:            GPLv2+
Provides:           iproute-static = %{version}-%{release}

%description devel
The libnetlink static library.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}2-%{version} -a 999
%patch0 -p1
sed -i "s/_VERSION_/%{version}/" man/man8/ss.8
%patch1 -p1 -b .kernel
%patch2 -p1 -b .opt_flags
%patch3 -p1 -b .share
%patch4 -p1 -b .ipproto
%patch5 -p1 -b .fix_cbq
%patch6 -p1 -b .print-route
%patch7 -p1 -b .peer-veth-without-name
%patch8 -p1 -b .lnstat-dump-to-stdout
%patch9 -p1 -b .unused-result
%patch10 -p1 -b .sigabrt-xfrm-state 

%patch104635 -p1

%build
export LIBDIR=/%{_libdir}
export IPT_LIB_DIR=/%{_lib}/xtables

./configure
make CC=%{__cc} %{?_smp_mflags}
make %{?_smp_mflags}
%if %{WITH_DOC}
make -C doc
%endif

pushd fivextra
make all
popd

%install
mkdir -p \
    %{buildroot}%{_includedir} \
    %{buildroot}%{_sbindir} \
    %{buildroot}%{_mandir}/man3 \
    %{buildroot}%{_mandir}/man7 \
    %{buildroot}%{_mandir}/man8 \
    %{buildroot}%{_datadir}/tc \
    %{buildroot}%{_libdir}/tc \
    %{buildroot}%{_sysconfdir}/iproute2 \
    %{buildroot}%{_sysconfdir}/sysconfig/cbq

for binary in \
    bridge/bridge \
    examples/cbq.init-%{cbq_version} \
    genl/genl \
    ip/ifcfg \
    ip/ip \
    ip/routef \
    ip/routel \
    ip/rtmon \
    ip/rtpr \
    misc/arpd \
    misc/ifstat \
    misc/lnstat \
    misc/nstat \
    misc/rtacct \
    misc/ss \
    tc/tc
    do install -m755 ${binary} %{buildroot}%{_sbindir}
done
mv %{buildroot}%{_sbindir}/cbq.init-%{cbq_version} %{buildroot}%{_sbindir}/cbq
cd %{buildroot}%{_sbindir}
    ln -s lnstat ctstat
    ln -s lnstat rtstat
cd -

# Libs
# if 0%{?fedora}
# install -m755 tc/q_atm.so %{buildroot}%{_libdir}/tc
# endif
install -m755 tc/m_xt.so %{buildroot}%{_libdir}/tc
cd %{buildroot}%{_libdir}/tc
    ln -s m_xt.so m_ipt.so
cd -

# libnetlink
install -m644 include/libnetlink.h %{buildroot}%{_includedir}
install -m644 lib/libnetlink.a %{buildroot}%{_libdir}

# Manpages
iconv -f latin1 -t utf8 man/man8/ss.8 > man/man8/ss.8.utf8 &&
    mv man/man8/ss.8.utf8 man/man8/ss.8
install -m644 man/man3/*.3 %{buildroot}%{_mandir}/man3
install -m644 man/man7/*.7 %{buildroot}%{_mandir}/man7
install -m644 man/man8/*.8 %{buildroot}%{_mandir}/man8

# Share files
for shared in \
    netem/normal.dist \
    netem/pareto.dist \
    netem/paretonormal.dist
    do install -m644 ${shared} %{buildroot}%{_datadir}/tc
done

# Config files
install -m644 etc/iproute2/* %{buildroot}%{_sysconfdir}/iproute2
for config in \
    %{SOURCE1} \
    %{SOURCE2}
    do install -m644 ${config} %{buildroot}%{_sysconfdir}/sysconfig/cbq
done

# Steps to package the iproute tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%dir %{_sysconfdir}/iproute2
%doc COPYING
%doc README README.decnet README.iproute2+tc README.distribution README.lnstat
%{_mandir}/man7/*
%{_mandir}/man8/*
%attr(644,root,root) %config(noreplace) %{_sysconfdir}/iproute2/*
%{_sbindir}/*
%dir %{_datadir}/tc
%{_datadir}/tc/*
%dir %{_libdir}/tc/
%{_libdir}/tc/*
%dir %{_sysconfdir}/sysconfig/cbq
%config(noreplace) %{_sysconfdir}/sysconfig/cbq/*

%if %{WITH_DOC}
%files doc
%doc COPYING
%doc doc/*.ps
%doc examples
%endif

%files devel
%doc COPYING
%{_mandir}/man3/*
%{_libdir}/libnetlink.a
%{_includedir}/libnetlink.h

%files fivextra
%{prefix}

%changelog
* Fri Jun 14 2013 baseuser@ibm.com
- Base-8.x spec file
