%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%global		package_version 0.4.1
%global		package_name mom

Name:		%{package_name}
Version:	0.4.1
%define base_release .1
Release:	1%{?release_suffix}%{?dist}%{?base_release}
Summary:	Dynamically manage system resources on virtualization hosts

Group:		Applications/System
License:	GPLv2
URL:		http://www.ovirt.org
Source:		 %{package_name}-%{package_version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release} 
BuildArch:	noarch
BuildRequires:	python-devel
BuildRequires:	python-nose

# MOM makes use of libvirt by way of the python bindings to monitor and
# interact with virtual machines.
%if 0%{?fedora} >= 18 || 0%{?rhel} >= 7 || 0%{?base} >= 18
Requires:	libvirt-daemon-driver-qemu
%else
Requires:	libvirt
%endif
Requires:	libvirt-python
Requires:	procps

Requires(post):		chkconfig
Requires(postun):	initscripts
Requires(preun):	chkconfig
Requires(preun):	initscripts

%description
MOM is a policy-driven tool that can be used to manage overcommitment on KVM
hosts. Using libvirt, MOM keeps track of active virtual machines on a host. At
a regular collection interval, data is gathered about the host and guests. Data
can come from multiple sources (eg. the /proc interface, libvirt API calls, a
client program connected to a guest, etc). Once collected, the data is
organized for use by the policy evaluation engine. When started, MOM accepts a
user-supplied overcommitment policy. This policy is regularly evaluated using
the latest collected data. In response to certain conditions, the policy may
trigger reconfiguration of the system’s overcommitment mechanisms. Currently
MOM supports control of memory ballooning and KSM but the architecture is
designed to accommodate new mechanisms such as cgroups.

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure --docdir="%{_pkgdocdir}"
make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make DESTDIR="%{buildroot}" install

install -d -m 0755 "%{buildroot}/%{_initrddir}"
install -m 0755 contrib/momd.init "%{buildroot}/%{_initrddir}/momd"
install -d -m 0755 "%{buildroot}/%{_sysconfdir}"
install -m 0644 doc/mom-balloon+ksm.conf "%{buildroot}/%{_sysconfdir}/momd.conf"

%check
#make check %{?_smp_mflags}

%post
/sbin/chkconfig --add momd

%preun
if [ $1 = 0 ] ; then
	/sbin/service momd stop >/dev/null 2>&1 || true
	/sbin/chkconfig --del momd || true
fi

%postun
if [ "$1" -ge "1" ] ; then
	/sbin/service momd condrestart >/dev/null 2>&1 || true
fi

%files
%config(noreplace) %{_sysconfdir}/momd.conf
%doc COPYING
%doc README
%{_initrddir}/momd
%{_sbindir}/momd
%{python_sitelib}/mom/


%changelog
* Tue Jul 15 2014 baseuser@ibm.com
- Base-f19.x spec file
