%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}

# Base disable python3 for now
# if 0%{?fedora}
# global with_python3 1
# endif

Name:           python-webtest
Version:        1.3.4
%define base_release .2
Release:        4%{?dist}%{?base_release}
Summary:        Helper to test WSGI applications

Group:          Development/Languages
License:        MIT
URL:            http://pythonpaste.org/webtest/
Source0:        http://pypi.python.org/packages/source/W/WebTest/WebTest-%{version}.tar.gz
BuildRoot:      %(mktemp -ud %{_tmppath}/%{name}-%{version}-%{release}-XXXXXX)

BuildArch:      noarch
BuildRequires:  python-setuptools
BuildRequires:  python-nose
BuildRequires:  python-webob
BuildRequires:  python-dtopt

%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
BuildRequires:  python3-nose
BuildRequires:  python3-webob1.2
BuildRequires:  python3-dtopt
%endif

Requires:       python-webob

%description
WebTest wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.

%if 0%{?with_python3}
%package -n python3-webtest
Summary:        Helper to test WSGI applications
Group:          Development/Languages

Requires:       python3-webtest

%description -n python3-webtest
WebTest wraps any WSGI application and makes it easy to send test
requests to that application, without starting up an HTTP server.

This provides convenient full-stack testing of applications written
with any WSGI-compatible framework.
%endif


%prep
%setup -q -n WebTest-%{version}

# Remove bundled egg info if it exists.
rm -rf *.egg-info

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif

%install
%{__rm} -rf %{buildroot}
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root %{buildroot}
popd
%endif

%{__python} setup.py install -O1 --skip-build --root %{buildroot}

%clean
%{__rm} -rf %{buildroot}

%check
PYTHONPATH=$(pwd) %{__python} setup.py test

%if 0%{?with_python3}
pushd %{py3dir}
PYTHONPATH=$(pwd) %{__python3} setup.py test
popd
%endif

%files
%doc docs/*
%{python_sitelib}/webtest
%{python_sitelib}/*.egg-info

%if 0%{?with_python3}
%files -n python3-webtest
%doc docs/*
%{python3_sitelib}/webtest
%{python3_sitelib}/*.egg-info
%endif

%changelog
* Tue Dec 17 2013 baseuser@ibm.com
- Base-8.x spec file
