Summary: Utilities for managing processes on your system
Name: psmisc
Version: 22.20
%define base_release .2
Release: 2%{?dist}%{?base_release}
License: GPLv2+
Group: Applications/System
Source: http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2
URL: http://sourceforge.net/projects/psmisc

BuildRequires: libselinux-devel
BuildRequires: gettext
BuildRequires: ncurses-devel
BuildRequires: autoconf automake

#The following has been reworked by upstream in a different way ... we'll see
#Patch1: psmisc-22.13-fuser-silent.patch

# Patch sent upstream 2012-10-08.
Patch2: psmisc-22.20-fix-selinux-in-pstree.patch

%description
The psmisc package contains utilities for managing processes on your
system: pstree, killall and fuser.  The pstree command displays a tree
structure of all of the running processes on your system.  The killall
command sends a specified signal (SIGTERM if nothing is specified) to
processes identified by name.  The fuser command identifies the PIDs
of processes that are using specified files or filesystems.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
AutoReq: no

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -a 999

%patch2 -p1

%build
%configure --prefix=%{_prefix} --enable-selinux
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR="$RPM_BUILD_ROOT"

mkdir -p $RPM_BUILD_ROOT/sbin
mv $RPM_BUILD_ROOT%{_bindir}/fuser $RPM_BUILD_ROOT/sbin

%find_lang %name

# Steps to package the psmisc tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files -f %{name}.lang
/sbin/fuser
%{_bindir}/killall
%{_bindir}/pstree
%{_bindir}/pstree.x11
%{_bindir}/prtstat
%{_mandir}/man1/fuser.1*
%{_mandir}/man1/killall.1*
%{_mandir}/man1/pstree.1*
%{_mandir}/man1/prtstat.1*
%ifarch %{ix86} x86_64 ppc ppc64 %{arm} mipsel ppcnf ppc476
%{_bindir}/peekfd
%endif
%{_mandir}/man1/peekfd.1*
%doc AUTHORS ChangeLog COPYING README

%files fivextra
%{prefix}

%changelog
* Fri May 10 2013 baseuser@ibm.com
- Base-8.x spec file
