%define name libvpd
%define version 2.2.3

Name:		%{name}
Version:	%{version}
%define base_release .3
Release:	1%{?dist}%{?base_release}
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:	VPD Database access library for lsvpd

Group:		System Environment/Libraries
License:	LGPLv2+
URL:		http://linux-diag.sf.net/Lsvpd.html
Source:		http://downloads.sourceforge.net/linux-diag/%{name}-%{version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:	sqlite-devel zlib-devel libstdc++-devel libtool

ExclusiveArch: ppc ppc64

%description
The libvpd package contains the classes that are used to access a vpd database
created by vpdupdate in the lsvpd package.

%package devel
Summary:	Header files for libvpd
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release} sqlite-devel pkgconfig
%description devel
Contains header files for building with libvpd.

%prep
%setup -q

%build
./bootstrap.sh
%configure --disable-static
%{__make} %{?_smp_mflags}

%clean 
%{__rm} -rf $RPM_BUILD_ROOT

%install
%{__rm} -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files 
%defattr(-,root,root,-)
%doc COPYING NEWS README AUTHORS
%exclude %{_libdir}/*.la
%{_libdir}/libvpd_cxx-2.2.so.*
%{_libdir}/libvpd-2.2.so.*
%{_sysconfdir}/udev/rules.d/90-vpdupdate.rules
%{_var}/lib/lsvpd/run.vpdupdate

%files devel
%defattr(-,root,root,-)
%exclude %{_libdir}/*.la
%{_includedir}/libvpd-2
%{_libdir}/libvpd_cxx.so
%{_libdir}/libvpd.so
%{_libdir}/pkgconfig/libvpd-2.pc
%{_libdir}/pkgconfig/libvpd_cxx-2.pc

%changelog
* Wed Aug 28 2013 baseuser@ibm.com
- Base-8.x spec file
