Summary: An encoder/decoder for the Free Lossless Audio Codec
Name: flac
Version: 1.3.0
%define base_release .3
Release: 2%{?dist}%{?base_release}
License: BSD and GPLv2+ and GFDL
Group: Applications/Multimedia

Source0: http://downloads.xiph.org/releases/flac/flac-%{version}.tar.xz
Source999: fivextra.tar.bz2
URL: http://www.xiph.org/flac/

Requires: %{name}-libs%{?_isa} = %{version}-%{release}

BuildRequires: libogg-devel
BuildRequires: automake autoconf libtool gettext-devel doxygen
%ifarch %{ix86}
# 2.0 supports symbol visibility
BuildRequires: nasm >= 2.0
%endif

Patch1: flac-metaflac_strcat.patch
Patch2: flac-no_rice_asm.patch
Patch81413: flac-1.2.1_flac_test.patch

%description
FLAC stands for Free Lossless Audio Codec. Grossly oversimplified, FLAC
is similar to Ogg Vorbis, but lossless. The FLAC project consists of
the stream format, reference encoders and decoders in library form,
flac, a command-line program to encode and decode FLAC files, metaflac,
a command-line metadata editor for FLAC files and input plugins for
various music players.

This package contains the command-line tools and documentation.

%package libs
Summary: Libraries for the Free Lossless Audio Codec
Group: System Environment/Libraries
Obsoletes: flac < 1.2.1-11

%description libs
FLAC stands for Free Lossless Audio Codec. Grossly oversimplified, FLAC
is similar to Ogg Vorbis, but lossless. The FLAC project consists of
the stream format, reference encoders and decoders in library form,
flac, a command-line program to encode and decode FLAC files, metaflac,
a command-line metadata editor for FLAC files and input plugins for
various music players.

This package contains the FLAC libraries.

%package devel
Summary: Development libraries and header files from FLAC
Group: Development/Libraries
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires: pkgconfig

%description devel
This package contains all the files needed to develop applications that
will use the Free Lossless Audio Codec.

%package fivextra
Summary: Tests for FIV
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -a 999
%patch1 -p1 -b .metaflac-strcat
%patch2 -p1 -b .no_rice_asm
%patch81413 -p1 -b .flac_test

%build
# use our libtool to avoid problems with RPATH
./autogen.sh -V

# -funroll-loops makes encoding about 10% faster
export CFLAGS="%{optflags} -funroll-loops"
%configure \
    --disable-xmms-plugin \
    --disable-silent-rules \
    --disable-thorough-tests

make %{?_smp_mflags}

pushd fivextra
make all
popd

pushd src/test_grabbag/cuesheet
make test_cuesheet
popd

pushd src/test_grabbag/picture
make test_picture
popd

pushd src/test_libFLAC++
make test_libFLAC++
popd

pushd src/test_libFLAC
make test_libFLAC
popd

%install
make install DESTDIR=%{buildroot}

# split documentation
mv %{buildroot}%{_docdir}/flac* ./flac-doc
mkdir -p flac-doc-devel
mv flac-doc{/html/api,-devel}
rm flac-doc/FLAC.tag

rm %{buildroot}%{_libdir}/*.la

install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/Test
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/src
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_streams
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_libs_common
# Copying & replacing these executables since the overwrtten files try to
# build an executable when running which is already built in the above make check
install -D src/test_grabbag/cuesheet/.libs/test_cuesheet $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_grabbag/cuesheet/test_cuesheet
install -D src/test_grabbag/picture/.libs/test_picture $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_grabbag/picture/test_picture
install -D src/test_libFLAC/test_libFLAC $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_libFLAC/test_libFLAC
install -D src/test_libFLAC++/.libs/test_libFLAC++ $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_libFLAC++/test_libFLAC++
install -D src/test_streams/* $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_streams
install -D src/test_libs_common/* $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_libs_common/

for dir in `cd test; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/Test/$dir
  install -m 755 `find test/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/Test/$dir
done

# Clean up object files
( cd $RPM_BUILD_ROOT/%{fivdir}/%{name}/Test/; \
        rm -rf lib* Makefile* *.o *.la *.a *.c *.lai *.so* )
( cd $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_libs_common/; \
        rm -rf  Makefile* *.o  *.a *.c *.lai  )
( cd $RPM_BUILD_ROOT/%{fivdir}/%{name}/src/test_streams/; \
        rm -rf  Makefile* *.o  *.a *.c *.lai  )

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make -C test check FLAC__TEST_LEVEL=0 &> /dev/null

%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig

%files
%doc flac-doc/*
%{_bindir}/flac
%{_bindir}/metaflac
%{_mandir}/man1/*

%files libs
%doc AUTHORS COPYING* README
%{_libdir}/*.so.*

%files devel
%doc flac-doc-devel/*
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%{_datadir}/aclocal/*.m4

%files fivextra
%{prefix}

%changelog
* Thu Jul 04 2013 baseuser@ibm.com
- Base-8.x spec file
