Name:           perl-HTTP-Cookies
Version:        6.01
%define base_release .2
Release:        5%{?dist}%{?base_release}
Summary:        HTTP cookie jars
License:        GPL+ or Artistic
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/HTTP-Cookies/
Source0:        http://www.cpan.org/authors/id/G/GA/GAAS/HTTP-Cookies-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(HTTP::Date) >= 6
BuildRequires:  perl(HTTP::Headers::Util) >= 6
# Tests only:
BuildRequires:  perl(HTTP::Request)
BuildRequires:  perl(HTTP::Response)
BuildRequires:  perl(Test)
BuildRequires:  perl(URI)
# Time::Local needed on MacOS only
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:       perl(HTTP::Date) >= 6
Requires:       perl(HTTP::Headers::Util) >= 6
Conflicts:      perl-libwww-perl < 6

# Remove underspecified dependencies
%filter_from_requires /^perl(HTTP::Date)\s*$/d
%filter_from_requires /^perl(HTTP::Headers::Util)\s*$/d
# One function of provided HTTP::Cookies::Microsoft works on Win32 only, other
# function do not need it. This keep the module, but remove dependency.
%filter_from_requires /^perl(Win32)/d
%filter_setup
%global __requires_exclude %{?__requires_exclude:%__requires_exclude|}perl\\(Win32|HTTP::Date|HTTP::Headers::Util\\)$


%description
This class is for objects that represent a "cookie jar" -- that is, a
database of all the HTTP cookies that a given LWP::UserAgent object
knows about.

%prep
%setup -q -n HTTP-Cookies-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} \;
%{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README
%{perl_vendorlib}/*
%{_mandir}/man3/*

%changelog
* Fri Sep 20 2013 baseuser@ibm.com
- Base-8.x spec file
