Name:           icoutils
Version:        0.30.0
%define base_release .2
Release:        3%{?dist}%{?base_release}
Summary:        Utility for extracting and converting Microsoft icon and cursor files

Group:          Applications/Multimedia
License:        GPLv3+
URL:            http://www.nongnu.org/icoutils/
Source0:        http://savannah.nongnu.org/download/%{name}/%{name}-%{version}.tar.bz2

BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  gettext 
BuildRequires:  libpng-devel
BuildRequires:  perl-Carp

Provides:       bundled(gnulib)

# Documentation fixes (RHBZ#948882).
# Sent upstream 2013-05-16.
Patch1:         icoutils-0.30.0-genresscript-add-options-to-man-page.patch
Patch2:         icoutils-0.30.0-icotool-document-raw-option.patch
Patch3:         icoutils-0.30.0-wrestool-document-a-option.patch
Patch4:         icoutils-0.30.0-wrestool-remove-bogus-r-option.patch

%description
The icoutils are a set of programs for extracting and converting images in
Microsoft Windows icon and cursor files. These files usually have the
extension .ico or .cur, but they can also be embedded in executables or
libraries.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

autoreconf

for f in AUTHORS NEWS; do
  iconv -f ISO88592 -t UTF8 < $f > $f.utf8 && \
  touch -r $f $f.utf8 && \
  mv $f.utf8 $f 
done

%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}
%find_lang %{name}


%files -f %{name}.lang
%doc README AUTHORS COPYING NEWS TODO ChangeLog
%{_bindir}/extresso
%{_bindir}/genresscript
%{_bindir}/icotool
%{_bindir}/wrestool
%{_mandir}/man1/*.1*


%changelog
* Fri Jul 12 2013 baseuser@ibm.com
- Base-8.x spec file
