Summary: Sample Authorization Protocol for X
Name: libXau
Version: 1.0.8
%define base_release .2
Release: 1%{?dist}%{?base_release}
License: MIT
Group: System Environment/Libraries
URL: http://www.x.org
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Source0: ftp://ftp.x.org/pub/individual/lib/%{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2

#Patch0: xau-1.0.4-local.patch

BuildRequires: xorg-x11-util-macros
BuildRequires: autoconf automake libtool
BuildRequires: pkgconfig
BuildRequires: xorg-x11-proto-devel

%description
This is a very simple mechanism for providing individual access to an X Window
System display.It uses existing core protocol and library hooks for specifying
authorization data in the connection setup block to restrict use of the display
to only those clients that show that they know a server-specific key 
called a "magic cookie".

%package devel
Summary: Development files for %{name}
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: xorg-x11-proto-devel
Requires: pkgconfig
BuildRequires: xorg-x11-proto-devel

%description devel
X.Org X11 libXau development package

%package fivextra
Summary: libXau functional tests
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
libXau tests

%prep
%setup -q -a 999
#patch0 -p1 -b .local

%build
autoreconf -v --install --force

%configure --disable-static
make %{?_smp_mflags}
make check || true

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"

# We intentionally don't ship *.la files
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

# Steps to package the libXau tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

tdir=$RPM_BUILD_ROOT/%{fivdir}/%{name}/tests
[ ! -d $tdir ] && install -d -m 755 $tdir
install -m 755 .libs/*test $tdir

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files fivextra
%{prefix}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING README ChangeLog
%{_libdir}/libXau.so.6
%{_libdir}/libXau.so.6.0.0

%files devel
%defattr(-,root,root,-)
%{_includedir}/X11/Xauth.h
%{_libdir}/libXau.so
%{_libdir}/pkgconfig/xau.pc
#%dir %{_mandir}/man3x
%{_mandir}/man3/*.3*

%changelog
* Fri Jul 05 2013 baseuser@ibm.com
- Base-8.x spec file
