%global fontname khmeros
%global archivename All_KhmerOS_%{version}

%global fontconf 65-0-%{fontname}

%global common_desc \
The Khmer OS fonts include Khmer and Latin alphabets, and they have equivalent \
sizes for Khmer and English alphabets, so that when texts mix both it is not \
necessary to have different point sizes for the text in each language. \
\
They were created by Danh Hong of the Cambodian Open Institute.


Name:           %{fontname}-fonts
Version:        5.0
%define base_release .1
Release:        16%{?dist}%{?base_release}
Summary:        Khmer font set created by Danh Hong of the Cambodian Open Institute

Group:          User Interface/X
License:        LGPLv2+
URL:            http://www.khmeros.info/drupal/?q=en/download/fonts
Source0:        http://downloads.sourceforge.net/khmer/%{archivename}.zip
Source1:        65-0-khmeros-battambang.conf
Source2:        65-0-khmeros-bokor.conf
Source3:        65-0-khmeros-handwritten.conf
Source4:        65-0-khmeros-base.conf
Source5:        65-0-khmeros-metal-chrieng.conf
Source6:        65-0-khmeros-muol.conf
Source7:        65-0-khmeros-siemreap.conf
Source8:        License.txt

BuildArch:      noarch
BuildRequires:  fontpackages-devel

%description
%common_desc


%package common
Summary:        Common files of %{name}
Group:          User Interface/X
Requires:       fontpackages-filesystem

%description common
%common_desc

This package consists of files used by other %{name} packages.


%package -n %{fontname}-base-fonts
Summary:        Base KhmerOS font
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-base-fonts
%common_desc

Base KhmerOS fonts.

%_font_pkg -n base -f 65-0-khmeros-base.conf KhmerOS.ttf KhmerOS_content.ttf KhmerOS_sys.ttf

%package -n %{fontname}-battambang-fonts
Summary:        Battambang font
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-battambang-fonts
%common_desc

Battambang font.

%_font_pkg -n battambang -f 65-0-khmeros-battambang.conf KhmerOS_battambang.ttf

%package -n %{fontname}-bokor-fonts
Summary:        Bokor font
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-bokor-fonts
%common_desc

Bokor font.

%_font_pkg -n bokor -f 65-0-khmeros-bokor.conf KhmerOS_bokor.ttf

%package -n %{fontname}-handwritten-fonts
Summary:        Freehand and fasthand fonts
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-handwritten-fonts
%common_desc

Freehand and fasthand - handwritten fonts.

%_font_pkg -n handwritten -f 65-0-khmeros-handwritten.conf KhmerOS_freehand.ttf KhmerOS_fasthand.ttf

%package -n %{fontname}-metal-chrieng-fonts
Summary:        Metal Chrieng font
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-metal-chrieng-fonts
%common_desc

Metal Chrieng font.

%_font_pkg -n metal-chrieng -f 65-0-khmeros-metal-chrieng.conf  KhmerOS_metalchrieng.ttf

%package -n %{fontname}-muol-fonts
Summary:        Muol fonts - normal, light and Pali
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-muol-fonts
%common_desc

Muol fonts - normal, light and Pali.

%_font_pkg -n muol -f 65-0-khmeros-muol.conf KhmerOS_muol.ttf KhmerOS_muollight.ttf KhmerOS_muolpali.ttf

%package -n %{fontname}-siemreap-fonts
Summary:        Siemreap font
Group:          User Interface/X
Requires:       %{name}-common = %{version}-%{release}

%description -n %{fontname}-siemreap-fonts
%common_desc

Siemreap font.

%_font_pkg -n siemreap -f 65-0-khmeros-siemreap.conf KhmerOS_siemreap.ttf


%prep
%setup -q -n %{archivename}
install -p %{SOURCE1} %{SOURCE2} %{SOURCE3} %{SOURCE4} .
install -p %{SOURCE5} %{SOURCE6} %{SOURCE7} %{SOURCE8} .


%build
#nothing

%install
# get rid of the white space (' ')
mv 'KhmerOS .ttf' KhmerOS.ttf

install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p *.ttf %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

for conffile in *.conf ; do
install -m 0644 -p $conffile %{buildroot}%{_fontconfig_templatedir}/${conffile}
ln -s %{_fontconfig_templatedir}/$conffile \
      %{buildroot}%{_fontconfig_confdir}/$conffile
done

%files common
%defattr(0644,root,root,0755)
%doc License.txt


%changelog
* Wed May 28 2014 baseuser@ibm.com
- Base-f19.x spec file
