Summary:        Utility to force unused ext2 inodes and blocks to zero
Name:           zerofree
Version:        1.0.1
%define base_release .2
Release:        12%{?dist}%{?base_release}
License:        GPL+
Group:          System Environment/Libraries

Source0:        http://intgat.tigress.co.uk/rmy/uml/%{name}-%{version}.tgz
Source1:        http://intgat.tigress.co.uk/rmy/uml/sparsify.c
Source2:        http://intgat.tigress.co.uk/rmy/uml/index.html

# zerofree.sgml is the source for the man page from Debian.
# Unfortunately we cannot build this in Fedora because of an apparent
# bug in our DocBook tools.  Therefore I also include the generated
# man page (generated on a Debian system from this source).
Source3:        zerofree.sgml
Source4:        zerofree.8

# e2fsprogs >= 1.42 prevents you from accessing the block group
# descriptor struct directly.
Patch1:         sparsify-opaque-group-desc.patch

URL:            http://intgat.tigress.co.uk/rmy/uml/

BuildRequires:  e2fsprogs-devel

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)


%description
zerofree is a utility to set unused filesystem inodes and blocks of an
ext2 filesystem to zero.  This can improve the compressibility and
privacy of an ext2 filesystem.

This tool was inspired by the ext2fs privacy (i.e. secure deletion)
patch described in a Linux kernel mailing list thread.

WARNING: The filesystem to be processed should be unmounted or mounted
read-only.  The tool tries to check this before running, but you
should be careful.


%prep
%setup -q
cp -p %{SOURCE1} .
cp -p %{SOURCE2} .
%patch1 -p1


%build
make CC="gcc $RPM_OPT_FLAGS"
gcc $RPM_OPT_FLAGS sparsify.c -o sparsify -lext2fs


%install
rm -rf $RPM_BUILD_ROOT

install -D -p -m 755 zerofree $RPM_BUILD_ROOT%{_sbindir}/zerofree
install -D -p -m 755 sparsify $RPM_BUILD_ROOT%{_sbindir}/sparsify
install -D -p -m 644 %{SOURCE4} $RPM_BUILD_ROOT%{_mandir}/man8/zerofree.8


%files
%defattr(-,root,root,-)
%doc COPYING index.html
%{_sbindir}/zerofree
%{_sbindir}/sparsify
%{_mandir}/man8/zerofree.8*


%clean
rm -rf $RPM_BUILD_ROOT


%changelog
* Tue Oct 08 2013 baseuser@ibm.com
- Base-8.x spec file
