%{!?python_sitearch: %define python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

Name: pycairo
Version: 1.8.10
%define base_release .3
Release: 6%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: MPLv1.1 or LGPLv2
Group: Development/Languages
Summary: Python bindings for the cairo library
URL: http://cairographics.org/pycairo
Source: http://cairographics.org/releases/py2cairo-%{version}.tar.gz
Source999: fivextra.tar.bz2

BuildRequires: cairo-devel
BuildRequires: pkgconfig
BuildRequires: python-devel

%description
Python bindings for the cairo library.

%package devel
Summary: Libraries and headers for pycairo
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: cairo-devel
Requires: pkgconfig
Requires: python-devel

%description devel
This package contains files required to build wrappers for cairo add-on
libraries so that they interoperate with pycairo.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: ImageMagick

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%build
%configure
make %{?_smp_mflags}

%install
make DESTDIR=$RPM_BUILD_ROOT install
find $RPM_BUILD_ROOT -name '*.la' | xargs rm -f
find $RPM_BUILD_ROOT -type f -name '*.pyo' | xargs rm -f
find $RPM_BUILD_ROOT -type f -name '*.pyc' | xargs rm -f

# Steps to package the pycairo tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find examples -type d)
do
  install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 $(find $dir/* -type d -prune -o -name '*.py' -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done
install -m 644 examples/cairo_snippets/data/romedalen.png $RPM_BUILD_ROOT/%{fivdir}/%{name}/examples/cairo_snippets/data/
mv $RPM_BUILD_ROOT/%{fivdir}/%{name}/examples $RPM_BUILD_ROOT/%{fivdir}/%{name}/tests

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING* INSTALL NEWS README
%doc examples doc/faq.rst doc/overview.rst doc/README
%{python_sitearch}/cairo/

%files devel
%defattr(-,root,root,-)
%{_includedir}/pycairo/
%{_libdir}/pkgconfig/pycairo.pc

%files fivextra
%{prefix}

%changelog
* Fri Jun 07 2013 baseuser@ibm.com
- Base-8.x spec file
