# -*- coding: utf-8 -*-
Summary: A GNU tool which simplifies the build process for users
Name: make
Epoch: 1
Version: 3.82
%define base_release .2
Release: 15%{?dist}%{?base_release}
License: GPLv2+
Group: Development/Tools
URL: http://www.gnu.org/software/make/
Source: ftp://ftp.gnu.org/gnu/make/make-%{version}.tar.bz2

Patch1: make-3.82-noclock_gettime.patch
Patch2: make-3.82-j8k.patch
Patch3: make-3.82-getcwd.patch
Patch4: make-3.82-err-reporting.patch

# Upstream: https://savannah.gnu.org/bugs/?30748
Patch6: make-3.82-weird-shell.patch

Patch7: make-3.82-newlines.patch
Patch8: make-3.82-jobserver.patch
Patch9: make-3.82-bugfixes.patch
Patch10: make-3.82-sort-blank.patch
Patch11: make-3.82-copy-on-expand.patch

# Upstream: https://savannah.gnu.org/bugs/?33873
Patch12: make-3.82-parallel-remake.patch

# http://savannah.gnu.org/bugs/?34335
Patch13: make-3.82-warn_undefined_function.patch

# http://lists.gnu.org/archive/html/bug-make/2011-06/msg00032.html
Patch14: make-3.82-trace.patch

# http://lists.gnu.org/archive/html/bug-make/2011-04/msg00002.html
Patch15: make-3.82-expensive_glob.patch

# Upstream: https://savannah.gnu.org/bugs/?30653
Patch16: make-3.82-dont-prune-intermediate.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
BuildRequires: procps

%description
A GNU tool for controlling the generation of executables and other
non-source files of a program from the program's source files. Make
allows users to build and install packages without any significant
knowledge about the details of the build process. The details about
how the program should be built are provided for make in the program's
makefile.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p0
%patch13 -p2
%patch14 -p1
%patch15 -p0
%patch16 -p0
rm -f tests/scripts/features/parallelism.orig

%build
%configure
make %{?_smp_mflags}

%install
rm -rf ${RPM_BUILD_ROOT}
make DESTDIR=$RPM_BUILD_ROOT install
ln -sf make ${RPM_BUILD_ROOT}/%{_bindir}/gmake
ln -sf make.1 ${RPM_BUILD_ROOT}/%{_mandir}/man1/gmake.1
rm -f ${RPM_BUILD_ROOT}/%{_infodir}/dir

%find_lang %name

%check
echo ============TESTING===============
/usr/bin/env LANG=C make check
echo ============END TESTING===========

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
if [ -f %{_infodir}/make.info.gz ]; then # for --excludedocs
   /sbin/install-info %{_infodir}/make.info.gz %{_infodir}/dir --entry="* Make: (make).                 The GNU make utility." || :
fi

%preun
if [ $1 = 0 ]; then
   if [ -f %{_infodir}/make.info.gz ]; then # for --excludedocs
      /sbin/install-info --delete %{_infodir}/make.info.gz %{_infodir}/dir --entry="* Make: (make).                 The GNU make utility." || :
   fi
fi

%files  -f %{name}.lang
%defattr(-,root,root)
%doc NEWS README COPYING AUTHORS
%{_bindir}/*
%{_mandir}/man*/*
%{_infodir}/*.info*

%changelog
* Thu May 09 2013 baseuser@ibm.com
- Base-7.x spec file
