Summary: The inittab file and the /etc/init.d scripts
Name: initscripts
Version: 9.47
# ppp-watch is GPLv2+, everything else is GPLv2
License: GPLv2 and GPLv2+
Group: System Environment/Base
%define base_release .5
Release: 1%{?dist}%{?base_release}
URL: http://fedorahosted.org/releases/i/n/initscripts/
Source: http://fedorahosted.org/releases/i/n/initscripts/initscripts-%{version}.tar.bz2
Source999: fivextra.tar.bz2

Patch1: 0001-install_bonding_driver-drop-check-for-existing-devic.patch
Patch97614: bug-97614-use_hwaddr_with_s390.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Obsoletes: initscripts-legacy <= 9.39
Requires: /bin/awk, sed, coreutils
Requires: /sbin/sysctl
Requires: grep
Requires: module-init-tools
Requires: util-linux >= 2.16
Requires: bash >= 3.0
Requires: sysvinit-tools >= 2.87-5
Conflicts: systemd < 23-1
Conflicts: systemd-units < 23-1
Conflicts: lvm2 < 2.02.98-3
Conflicts: dmraid < 1.0.0.rc16-18
Requires: systemd
Requires: iproute, /sbin/arping, findutils
# Not strictly required, but nothing else requires it
Requires: /etc/system-release
Requires: udev >= 125-1
Requires: cpio
Requires: hostname
Conflicts: ipsec-tools < 0.8.0-2
Requires(pre): /usr/sbin/groupadd
Requires(post): /sbin/chkconfig, coreutils
Requires(preun): /sbin/chkconfig
BuildRequires: glib2-devel popt-devel gettext pkgconfig
Provides: /sbin/service

%description
The initscripts package contains the basic system scripts used to boot
your Red Hat or Fedora system, change runlevels, and shut the system down
cleanly.  Initscripts also contains the scripts that activate and
deactivate most network interfaces.

%package -n debugmode
Summary: Scripts for running in debugging mode
Requires: initscripts
Group: System Environment/Base

%description -n debugmode
The debugmode package contains some basic scripts that are used to run
the system in a debugging mode.

Currently, this consists of various memory checking code.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
%patch1 -p1
%patch97614 -p1

%build
export CC=%{__cc}
%if 0%{?cross_build}
sed -i 's/-z relro -z now//g' src/Makefile 
%endif
make

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
make ROOT=$RPM_BUILD_ROOT SUPERUSER=`id -un` SUPERGROUP=`id -gn` mandir=%{_mandir} install

# Steps to package the initscripts tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %{name}

%ifnarch s390 s390x
rm -f \
 $RPM_BUILD_ROOT/etc/sysconfig/network-scripts/ifup-ctc \
%else
rm -f \
 $RPM_BUILD_ROOT/etc/sysconfig/init.s390
%endif

touch $RPM_BUILD_ROOT/etc/crypttab
chmod 600 $RPM_BUILD_ROOT/etc/crypttab

%pre
/usr/sbin/groupadd -g 22 -r -f utmp

%post
touch /var/log/wtmp /var/run/utmp /var/log/btmp
chown root:utmp /var/log/wtmp /var/run/utmp /var/log/btmp
chmod 664 /var/log/wtmp /var/run/utmp
chmod 600 /var/log/btmp

/usr/sbin/chkconfig --add network
/usr/sbin/chkconfig --add netconsole
if [ $1 -eq 1 ]; then
        /usr/bin/systemctl daemon-reload > /dev/null 2>&1 || :
fi

%preun
if [ $1 = 0 ]; then
  /usr/sbin/chkconfig --del network
  /usr/sbin/chkconfig --del netconsole
fi

%triggerun -- initscripts < 7.62
/usr/sbin/chkconfig --del random
/usr/sbin/chkconfig --del rawdevices
exit 0

%postun
if [ $1 -ge 1 ]; then
  /usr/bin/systemctl daemon-reload > /dev/null 2>&1 || :
fi

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-,root,root)
%dir /etc/sysconfig/network-scripts
%config(noreplace) %verify(not md5 mtime size) /etc/adjtime
%config(noreplace) /etc/sysconfig/init
%config(noreplace) /etc/sysconfig/netconsole
%config(noreplace) /etc/sysconfig/readonly-root
/etc/sysconfig/network-scripts/ifdown
/usr/sbin/ifdown
/etc/sysconfig/network-scripts/ifdown-post
/etc/sysconfig/network-scripts/ifup
/usr/sbin/ifup
%dir /etc/sysconfig/console
%dir /etc/sysconfig/modules
/etc/sysconfig/network-scripts/network-functions
/etc/sysconfig/network-scripts/network-functions-ipv6
/etc/sysconfig/network-scripts/init.ipv6-global
%config(noreplace) /etc/sysconfig/network-scripts/ifcfg-lo
/etc/sysconfig/network-scripts/ifup-ipx
/etc/sysconfig/network-scripts/ifup-post
/etc/sysconfig/network-scripts/ifdown-ppp
/etc/sysconfig/network-scripts/ifup-ppp
/etc/sysconfig/network-scripts/ifup-routes
/etc/sysconfig/network-scripts/ifdown-routes
/etc/sysconfig/network-scripts/ifup-plip
/etc/sysconfig/network-scripts/ifup-plusb
/etc/sysconfig/network-scripts/ifup-bnep
/etc/sysconfig/network-scripts/ifdown-bnep
/etc/sysconfig/network-scripts/ifup-eth
/etc/sysconfig/network-scripts/ifdown-eth
/etc/sysconfig/network-scripts/ifup-ipv6
/etc/sysconfig/network-scripts/ifdown-ipv6
/etc/sysconfig/network-scripts/ifup-sit
/etc/sysconfig/network-scripts/ifdown-sit
/etc/sysconfig/network-scripts/ifup-tunnel
/etc/sysconfig/network-scripts/ifdown-tunnel
/etc/sysconfig/network-scripts/ifup-aliases
/etc/sysconfig/network-scripts/ifup-ippp
/etc/sysconfig/network-scripts/ifdown-ippp
/etc/sysconfig/network-scripts/ifup-wireless
/etc/sysconfig/network-scripts/ifup-isdn
/etc/sysconfig/network-scripts/ifdown-isdn
%ifarch s390 s390x
/etc/sysconfig/network-scripts/ifup-ctc
%endif
%config(noreplace) /etc/networks
/etc/rwtab
%dir /etc/rwtab.d
/etc/statetab
%dir /etc/statetab.d
/usr/lib/systemd/fedora-*
/usr/lib/systemd/system/*
/etc/inittab
%dir /etc/rc.d
%dir /etc/rc.d/rc[0-9].d
/etc/rc[0-9].d
%dir /etc/rc.d/init.d
/etc/rc.d/init.d/*
%config(noreplace) /etc/sysctl.conf
/usr/lib/sysctl.d/00-system.conf
%exclude /etc/profile.d/debug*
/etc/profile.d/*
/usr/sbin/sys-unconfig
/usr/bin/ipcalc
/usr/bin/usleep
%attr(4755,root,root) /usr/sbin/usernetctl
/usr/sbin/consoletype
/usr/sbin/genhostid
/usr/sbin/sushell
%attr(2755,root,root) /usr/sbin/netreport
/usr/lib/udev/rules.d/*
/usr/lib/udev/rename_device
/usr/sbin/service
/usr/sbin/ppp-watch
%{_mandir}/man*/*
%dir %attr(775,root,root) /var/run/netreport
%dir /etc/ppp
%dir /etc/ppp/peers
/etc/ppp/ip-up
/etc/ppp/ip-down
/etc/ppp/ip-up.ipv6to4
/etc/ppp/ip-down.ipv6to4
/etc/ppp/ipv6-up
/etc/ppp/ipv6-down
%dir /etc/NetworkManager
%dir /etc/NetworkManager/dispatcher.d
/etc/NetworkManager/dispatcher.d/00-netreport
%doc sysconfig.txt sysvinitfiles static-routes-ipv6 ipv6-tunnel.howto ipv6-6to4.howto changes.ipv6 COPYING
/var/lib/stateless
%ghost %attr(0600,root,utmp) /var/log/btmp
%ghost %attr(0664,root,utmp) /var/log/wtmp
%ghost %attr(0664,root,utmp) /var/run/utmp
%ghost %verify(not md5 size mtime) %config(noreplace,missingok) /etc/crypttab
%dir /usr/lib/tmpfiles.d
/usr/lib/tmpfiles.d/initscripts.conf
%dir /usr/libexec/initscripts
%dir /usr/libexec/initscripts/legacy-actions

%files -n debugmode
%defattr(-,root,root)
%config(noreplace) /etc/sysconfig/debug
/etc/profile.d/debug*

%files fivextra
%{prefix}

%changelog
* Thu Jul 04 2013 baseuser@ibm.com
- Base-8.x spec file
