Name:           dtc
Version:        1.3.0
%define base_release .2
Release:        8%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Summary:        Device Tree Compiler
Group:          Development/Tools
License:        GPLv2+
URL:            http://git.jdl.com/gitweb/?p=dtc.git;a=summary
Source:         http://www.jdl.com/software/dtc-v%{version}.tgz
Patch0:         dtc-update.patch
Patch1:         use-tx-as-the-type-specifier-instead-of-zx.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  flex, bison

%description
The Device Tree Compiler generates flattened Open Firmware style device trees
for use with PowerPC machines that lack an Open Firmware implementation

%package -n libfdt
Summary: Device tree library
Group: Development/Libraries

%description -n libfdt
libfdt is a library to process Open Firmware style device trees on various
architectures.

%package -n libfdt-devel
Summary: Development headers for device tree library
Group: Development/Libraries
Requires: libfdt = %{version}-%{release}

%description -n libfdt-devel
This package provides development files for libfdt

%prep
%setup -q -n dtc-v%{version}
%patch0 -p1
%patch1 -p1

%build
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT PREFIX=/usr LIBDIR=%{_libdir}
rm -rf $RPM_BUILD_ROOT/%{_libdir}/*.a

# we don't want or need ftdump and it conflicts with freetype-demos, so drop
# it (rhbz 797805)
rm -f $RPM_BUILD_ROOT/%{_bindir}/ftdump

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc GPL
%{_bindir}/*

%files -n libfdt
%defattr(-,root,root,-)
%doc GPL
%{_libdir}/libfdt-%{version}.so
%{_libdir}/libfdt.so.*

%files -n libfdt-devel
%defattr(-,root,root,-)
%{_libdir}/libfdt.so
%{_includedir}/*

%post -n libfdt
/sbin/ldconfig

%postun -n libfdt
/sbin/ldconfig

%changelog
* Wed Jul 10 2013 baseuser@ibm.com
- Base-8.x spec file
