%global fontname stix
%global fontconf 61-%{fontname}

%global archivename STIXv%{version}

%global common_desc \
The mission of the Scientific and Technical Information Exchange (STIX) font \
creation project is the preparation of a comprehensive set of fonts that serve \
the scientific and engineering community in the process from manuscript \
creation through final publication, both in electronic and print formats.

Name:    %{fontname}-fonts
Version: 1.1.0
%define base_release .1
Release: 4%{?dist}%{?base_release}
Summary: Scientific and engineering fonts

Group:   User Interface/X
License: OFL
URL:     http://www.stixfonts.org/
Source0:  http://downloads.sourceforge.net/stixfonts/%{archivename}.zip
Source10: stix-fonts-fontconfig.conf
Source11: stix-fonts-math-fontconfig.conf

BuildArch:     noarch
BuildRequires: fontpackages-devel
Requires:      fontpackages-filesystem

Obsoletes:     stix-fonts-doc < 1.1.0

%description
%common_desc

This package includes base Unicode fonts containing most glyphs for standard
use in the usual four styles.

%_font_pkg -f %{fontconf}.conf STIX-*otf
%doc License/*.pdf *.pdf


%package -n %{fontname}-math-fonts
Summary:   Scientific and engineering fonts, PUA glyphs
Requires:  %{name} = %{version}-%{release}

Obsoletes: stix-integrals-fonts < 1.1.0
Obsoletes: stix-pua-fonts < 1.1.0
Obsoletes: stix-sizes-fonts < 1.1.0
Obsoletes: stix-variants-fonts < 1.1.0


%description -n %{fontname}-math-fonts
%common_desc

This package includes one symbol font completing the four faces in the main
%{name} package. It replaces the heap of confusing fontlets in the first Stix
release.

%_font_pkg -n math -f %{fontconf}-math.conf STIXMath*otf


%prep
%setup -q -c


%build


%install
rm -fr %{buildroot}

install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p Fonts/STIX-Word/*.otf %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE10} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}.conf
install -m 0644 -p %{SOURCE11} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}-math.conf

for fconf in %{fontconf}.conf \
             %{fontconf}-math.conf ; do
  ln -s %{_fontconfig_templatedir}/$fconf \
        %{buildroot}%{_fontconfig_confdir}/$fconf
done


%clean
rm -fr %{buildroot}


%changelog
* Thu May 29 2014 baseuser@ibm.com
- Base-f19.x spec file
