Name:		perl-Net-SSLeay
Version:	1.54
%define base_release .4
Release:	1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Summary:	Perl extension for using OpenSSL
Group:		Development/Libraries
License:	OpenSSL
URL:		http://search.cpan.org/dist/Net-SSLeay/
Source0:	http://search.cpan.org/CPAN/authors/id/M/MI/MIKEM/Net-SSLeay-%{version}.tar.gz
Source999:     fivextra.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -nu)
BuildRequires:	openssl, openssl-devel
# =========== Module Build ===========================
BuildRequires:	perl(Cwd)
BuildRequires:	perl(ExtUtils::MakeMaker)
BuildRequires:	perl(File::Path)
BuildRequires:	perl(lib)
# =========== Module Runtime =========================
BuildRequires:	perl(AutoLoader)
BuildRequires:	perl(Carp)
BuildRequires:	perl(Exporter)
BuildRequires:	perl(MIME::Base64)
BuildRequires:	perl(Socket)
BuildRequires:	perl(XSLoader)
# =========== Test Suite =============================
BuildRequires:	perl(File::Spec)
BuildRequires:	perl(IO::Handle)
BuildRequires:	perl(Test::Exception)
# Test::Kwalitee => Module::CPANTS::Analyze => Net::HTTP => IO::Socket::SSL => Net::SSLeay
# Net::SSLeay in RHEL-7 cannot BR: Test::Kwalitee from EPEL-7
%if 0%{!?perl_bootstrap:1} && 0%{?rhel} < 7 && 0%{?fedora} < 19 
BuildRequires:	perl(Test::Kwalitee)
%endif
BuildRequires:	perl(Test::More)
BuildRequires:	perl(Test::NoWarnings)
BuildRequires:	perl(Test::Pod)
BuildRequires:	perl(Test::Pod::Coverage)
BuildRequires:	perl(Test::Warn)
BuildRequires:	perl(threads)
Requires:	perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:	perl(MIME::Base64)
Requires:	perl(XSLoader)

# Don't "provide" private Perl libs or the redundant unversioned perl(Net::SSLeay) provide
%global __provides_exclude ^(perl\\(Net::SSLeay\\)$|SSLeay\\.so)

%description
This module offers some high level convenience functions for accessing
web pages on SSL servers (for symmetry, same API is offered for
accessing http servers, too), a sslcat() function for writing your own
clients, and finally access to the SSL API of SSLeay/OpenSSL package
so you can write servers or clients for more complicated applications.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
AutoProv: no
Prefix: /opt/fiv/ltp
Requires: perl-Test-Simple

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n Net-SSLeay-%{version} -a 999

# Fix permissions in examples to avoid bogus doc-file dependencies
chmod -c 644 examples/*

# Remove redundant unversioned provide if we don't have rpm 4.9 or later
%global provfilt /bin/sh -c "%{__perl_provides} | grep -Fvx 'perl(Net::SSLeay)'"
%define __perl_provides %{provfilt}

%build
PERL_MM_USE_DEFAULT=1 perl Makefile.PL \
	INSTALLDIRS=vendor \
	OPTIMIZE="%{optflags}"
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
find %{buildroot} -type f -name '*.bs' -empty -exec rm -f {} ';'
%{_fixperms} %{buildroot}

# Remove script we don't want packaged
rm -f %{buildroot}%{perl_vendorarch}/Net/ptrtstrun.pl

# Steps to package the perl-Net-SSLeay tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find t -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make test

%clean
rm -rf %{buildroot}

%files
%doc Changes Credits QuickRef README examples/
%{perl_vendorarch}/auto/Net/
%dir %{perl_vendorarch}/Net/
%{perl_vendorarch}/Net/SSLeay/
%{perl_vendorarch}/Net/SSLeay.pm
%doc %{perl_vendorarch}/Net/SSLeay.pod
%{_mandir}/man3/Net::SSLeay.3pm*
%{_mandir}/man3/Net::SSLeay::Handle.3pm*

%files fivextra
%{prefix}

%changelog
* Wed Jun 26 2013 baseuser@ibm.com
- Base-8.x spec file
