Summary: Utilities for managing filesystem extended attributes
Name: attr
Version: 2.4.46
%define base_release .2
Release: 10%{?dist}%{?base_release}
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Source: http://download.savannah.gnu.org/releases-noredirect/attr/attr-%{version}.src.tar.gz
Source999: fivextra.tar.bz2

# make it ready for rpmbuild
Patch1: attr-2.4.32-build.patch

# prepare the test-suite for SELinux
Patch3: attr-2.4.44-tests.patch

# silence compile-time warnings
Patch4: attr-2.4.44-warnings.patch

# getfattr: return non-zero exit code on failure (#660619)
Patch7: attr-2.4.44-bz660619.patch

# walk_tree: do not follow symlink to directory with -h (#660613)
Patch8: attr-2.4.44-bz660613.patch

# fix typos in attr(1) man page (#669095)
Patch9: attr-2.4.44-bz669095.patch

# use <sys/syscalls.h> to fix build on aarch64 (#957989)
Patch10: attr-2.4.44-bz957989.patch

License: GPLv2+
URL: http://acl.bestbits.at/
Group: System Environment/Base
BuildRequires: gettext
BuildRequires: libtool
Requires: libattr = %{version}-%{release}

%description
A set of tools for manipulating extended attributes on filesystem
objects, in particular getfattr(1) and setfattr(1).
An attr(1) command is also provided which is largely compatible
with the SGI IRIX tool of the same name.

%package -n libattr
Summary: Dynamic library for extended attribute support
Group: System Environment/Libraries
License: LGPLv2+
Conflicts: filesystem < 3

%description -n libattr
This package contains the libattr.so dynamic library which contains
the extended attribute system calls and library functions.

%package -n libattr-devel
Summary: Files needed for building programs with libattr
Group: Development/Libraries
License: LGPLv2+
Requires: libattr = %{version}-%{release}

%description -n libattr-devel
This package contains header files and documentation needed to
develop programs which make use of extended attributes.
For Linux programs, the documented system call API is the
recommended interface, but an SGI IRIX compatibility interface
is also provided.

Currently only ext2, ext3 and XFS support extended attributes.
The SGI IRIX compatibility API built above the Linux system calls is
used by programs such as xfsdump(8), xfsrestore(8) and xfs_fsr(8).

You should install libattr-devel if you want to develop programs
which make use of extended attributes.  If you install libattr-devel,
you'll also want to install attr.

%package fivextra 
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -a 999
%patch1 -p1
%patch3 -p1
%patch4 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1

%build
# attr <= 2.4.46 abuses libexecdir (fixed upstream in 2971df45)
%configure --libexecdir=%{_libdir}

# uncomment to turn off optimizations
# sed -i 's/-O2/-O0/' libtool include/builddefs
# unset CFLAGS

make %{?_smp_mflags} LIBTOOL="libtool --tag=CC"

%check
if ./setfattr/setfattr -n user.name -v value .; then
    make tests || exit $?

    # FIXME: root-tests are not ready for the SELinux
    #if test 0 = `id -u`; then
    #    make root-tests || exit $?
    #fi
else
    echo '*** xattrs are probably not supported by the file system,' \
         'the test-suite will NOT run ***'
fi

%install
make install DESTDIR=$RPM_BUILD_ROOT
make install-dev DESTDIR=$RPM_BUILD_ROOT
make install-lib DESTDIR=$RPM_BUILD_ROOT

# get rid of libattr.a and libattr.la
rm -f $RPM_BUILD_ROOT/%{_lib}/libattr.a
rm -f $RPM_BUILD_ROOT/%{_lib}/libattr.la
rm -f $RPM_BUILD_ROOT%{_libdir}/libattr.a
rm -f $RPM_BUILD_ROOT%{_libdir}/libattr.la

chmod 0755 $RPM_BUILD_ROOT/%{_libdir}/libattr.so.*.*.*

#FIV Changes
mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}
cp -a test $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests
for dir in `cd fivextra; find . -type d -not -name CVS`
do
 install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %{name}

%post -n libattr -p /sbin/ldconfig

%postun -n libattr -p /sbin/ldconfig

%files -f %{name}.lang
%doc doc
%{_bindir}/attr
%{_bindir}/getfattr
%{_bindir}/setfattr
%{_mandir}/man1/attr.1*
%{_mandir}/man1/getfattr.1*
%{_mandir}/man1/setfattr.1*
%{_mandir}/man5/attr.5*

%files -n libattr-devel
%{_libdir}/libattr.so
%{_includedir}/attr
%{_mandir}/man2/*attr.2*
%{_mandir}/man3/attr_*.3.*

%files -n libattr
%{_libdir}/libattr.so.*

%files fivextra
/%{prefix}

%changelog
* Tue Jun 04 2013 baseuser@ibm.com
- Base-8.x spec file
