Name:           perl-Config-General
Version:        2.51
%define base_release .2
Release:        2%{?dist}%{?base_release}
# MCP: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        Generic configuration module for Perl

Group:          Development/Libraries
License:        GPL+ or Artistic
URL:            http://search.cpan.org/dist/Config-General/
Source0:        http://www.cpan.org/authors/id/T/TL/TLINDEN/Config-General-%{version}.tar.gz
Source999:	fivextra.tar.bz2
Patch0:         %{name}-2.50-system-ixhash.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  perl(ExtUtils::MakeMaker)
# Run-time:
BuildRequires:  perl(base)
BuildRequires:  perl(Carp)
BuildRequires:  perl(Carp::Heavy)
BuildRequires:  perl(Exporter)
BuildRequires:  perl(File::Spec::Functions)
BuildRequires:  perl(IO::File)
# Tests:
BuildRequires:  perl(Data::Dumper)
BuildRequires:  perl(Test::More)
BuildRequires:  perl(Tie::IxHash)
Requires:  perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))

%description
This module opens a config file and parses its contents for
you. After parsing the module returns a hash structure which contains
the representation of the config file.
The format of config files supported by Config::General is inspired by
the well known Apache config format, in fact, this module is 100%
read-compatible with Apache configs, but you can also just use simple
name/value pairs in your config files.
In addition to the capabilities of an Apache config file it supports
some enhancements such as here-documents, C-style comments or
multiline options. It is also possible to save the config back to
disk, which makes the module a perfect backend for configuration
interfaces.
It is possible to use variables in config files and there exists also
support for object oriented access to the configuration.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: rpm
Requires: perl

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n Config-General-%{version} -a 999
%patch0 -p1
rm -r t/Tie # see patch0
f=Changelog ; iconv -f iso-8859-1 -t utf-8 -o $f.utf8 $f ; mv $f.utf8 $f


%build
%{__perl} Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null ';'
%{_fixperms} $RPM_BUILD_ROOT/*


%check
make test

# Steps to package the perl-libxml-perl tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
	install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
	install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find t -type d )
do
	install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
	install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir || true 
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc Changelog README example.cfg
%{perl_vendorlib}/Config/
%{_mandir}/man3/Config::*.3*

%files fivextra
%{prefix}

%changelog
* Tue Aug 20 2013 baseuser@ibm.com
- Base-8.x spec file
