### Abstract ###

Name: python-ldap
Version: 2.4.6
%define base_release .2
Release: 4%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Epoch: 0
License: Python
Group: System Environment/Libraries
Summary: An object-oriented API to access LDAP directory servers
URL: http://python-ldap.sourceforge.net/
Source0: http://pypi.python.org/packages/source/p/python-ldap/python-ldap-%{version}.tar.gz
Source999: fivextra.tar.bz2

### Patches ###
# Fedora specific patch
Patch0: python-ldap-2.4.6-dirs.patch

### Dependencies ###

Requires: openldap 

### Build Dependencies ###

BuildRequires: openldap-devel
BuildRequires: openssl-devel
BuildRequires: python2-devel 
BuildRequires: cyrus-sasl-devel

# we don't want to provide private python extension libs
%{?filter_setup:
%filter_provides_in %{python_sitearch}/.*\.so$
%filter_setup
}

%description
python-ldap provides an object-oriented API for working with LDAP within
Python programs.  It allows access to LDAP directory servers by wrapping the 
OpenLDAP 2.x libraries, and contains modules for other LDAP-related tasks 
(including processing LDIF, LDAPURLs, LDAPv3 schema, etc.).

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n python-ldap-%{version} -a 999
%patch0 -p1 -b .dirs

# clean up cvs hidden files
rm -rf Demo/Lib/ldap/.cvsignore Demo/.cvsignore Demo/Lib/ldif/.cvsignore Demo/Lib/ldap/async/.cvsignore \
       Demo/Lib/.cvsignore Demo/Lib/ldapurl/.cvsignore

# Fix interpreter
sed -i 's|#! python|#!/usr/bin/python|g' Demo/simplebrowse.py

%build
%{__python} setup.py build

pushd fivextra
make all
popd

%install
%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT

# Steps to package the python-ldap tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find Tests -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -m 755 Demo/matchedvalues.py Demo/resiter.py Demo/Lib/ldap/async/ldifwriter.py Demo/initialize.py  $RPM_BUILD_ROOT/%{fivdir}/%{name}/Tests/

install -m 755 $RPM_BUILD_ROOT/%{fivdir}/%{name}/sasl.py $RPM_BUILD_ROOT/%{fivdir}/%{name}/slapd.conf $RPM_BUILD_ROOT/%{fivdir}/%{name}/t_setupslapd.py $RPM_BUILD_ROOT/%{fivdir}/%{name}/Tests/

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%defattr(-,root,root,-)
%doc LICENCE CHANGES README TODO Demo
%{python_sitearch}/_ldap.so
%{python_sitearch}/dsml.py*
%{python_sitearch}/ldapurl.py*
%{python_sitearch}/ldif.py*
%{python_sitearch}/ldap/
%{python_sitearch}/python_ldap-%{version}-*.egg-info

%files fivextra
%{prefix}

%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
