Name:           cryptopp
Version:        5.6.2
%define base_release .2
Release:        2%{?dist}%{?base_release}
Summary:        C++ class library of cryptographic schemes
License:        Boost
Group:          System Environment/Libraries
URL:            http://www.cryptopp.com/
Source0:        http://www.cryptopp.com/cryptopp562.zip
Source1:        cryptopp.pc
Patch0:         cryptopp-autotools.patch
Patch1:         cryptopp-s390.patch
# Debian patch installs TestVectors and TestData in /usr/share/cryptopp/
# http://groups.google.com/group/cryptopp-users/browse_thread/thread/6fe2192340f07e5d
Patch2:         cryptopp-data-files-location.patch
# Enable SSE2 only on x86_64
Patch3:         cryptopp-x86-disable-sse2.patch
BuildRequires:  doxygen, autoconf, libtool
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%description
Crypto++ Library is a free C++ class library of cryptographic schemes.
See http://www.cryptopp.com/ for a list of supported algorithms.

One purpose of Crypto++ is to act as a repository of public domain
(not copyrighted) source code. Although the library is copyrighted as a
compilation, the individual files in it are in the public domain.


%package devel
Summary:        Header files and development documentation for %{name}
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig
%description devel
Crypto++ Library is a free C++ class library of cryptographic schemes.

This package contains the header files and development documentation
for %{name}.

%package doc
Summary:        Documentation for %{name}
Group:          Documentation
BuildArch:      noarch

%description doc
Crypto++ Library is a free C++ class library of cryptographic schemes.

This package contains documentation for %{name}.

%package progs
Summary:        Programs for manipulating %{name} routines
Group:          Development/Tools
Requires:       %{name} = %{version}-%{release}

%description progs
Crypto++ Library is a free C++ class library of cryptographic schemes.

This package contains programs for manipulating %{name} routines.

%prep
%setup -q -c
rm -f GNUmakefile
%patch0 -p1
%patch1 -p1 -b .s390
%patch2 -p1
%patch3
autoreconf --verbose --force --install
perl -pi -e 's/\r$//g' License.txt Readme.txt

%build
%configure --disable-static

make %{?_smp_mflags}
doxygen

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p -c "
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

# Install the pkg-config file
install -D -m644 %{SOURCE1} $RPM_BUILD_ROOT%{_libdir}/pkgconfig/cryptopp.pc
# Fill in the variables
sed -i "s|@PREFIX@|%{_prefix}|g" $RPM_BUILD_ROOT%{_libdir}/pkgconfig/cryptopp.pc
sed -i "s|@LIBDIR@|%{_libdir}|g" $RPM_BUILD_ROOT%{_libdir}/pkgconfig/cryptopp.pc

mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/TestVectors
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}/TestData
install -m644 TestVectors/* $RPM_BUILD_ROOT%{_datadir}/%{name}/TestVectors
install -m644 TestData/* $RPM_BUILD_ROOT%{_datadir}/%{name}/TestData

rm -f $RPM_BUILD_ROOT%{_bindir}/cryptestcwd

%check
./cryptestcwd v

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(0644,root,root,0755)
%doc License.txt Readme.txt
%defattr(-,root,root,0755)
%{_libdir}/libcryptopp.so.6*

%files devel
%defattr(0644,root,root,0755)
%{_includedir}/cryptopp
%defattr(-,root,root,0755)
%{_libdir}/libcryptopp.so
%{_libdir}/pkgconfig/cryptopp.pc

%files doc
%defattr(0644,root,root,0755)
%doc doc/html/*

%files progs
%defattr(0644,root,root,0755)
%attr(0755,root,root) %{_bindir}/cryptest
%{_datadir}/%{name}


%changelog
* Tue Jun 04 2013 baseuser@ibm.com
- Base-8.x spec file
