%if 0%{?fedora}
%bcond_with long_tests
%else
%bcond_without long_tests
%endif

%{?perl_default_filter}

Name:           perl-IO-Compress
Version:        2.060
%define base_release .4
Release:        2%{?dist}%{?base_release}
Summary:        Read and write compressed data
License:        GPL+ or Artistic
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/IO-Compress/
Source0:        http://search.cpan.org/CPAN/authors/id/P/PM/PMQS/IO-Compress-%{version}.tar.gz
Source999:      fivextra.tar.bz2
BuildArch:      noarch
BuildRequires:  perl(Carp)
BuildRequires:  perl(Compress::Raw::Bzip2) >= %{version}
BuildRequires:  perl(Compress::Raw::Zlib) >= %{version}
BuildRequires:  perl(constant)
BuildRequires:  perl(Encode)
BuildRequires:  perl(Exporter)
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(File::Path)
BuildRequires:  perl(File::Spec)
BuildRequires:  perl(File::Temp)
BuildRequires:  perl(IO::File)
BuildRequires:  perl(IO::Handle)
BuildRequires:  perl(IO::Seekable)
BuildRequires:  perl(lib)
BuildRequires:  perl(List::Util)
BuildRequires:  perl(Scalar::Util)
# Dual-lived module needs building early in the boot process
%if !%{defined perl_bootstrap}
BuildRequires:  perl(Test::NoWarnings)
BuildRequires:  perl(Test::Pod) >= 1.00
%endif
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
# this is wrapper for different Compress modules
Obsoletes:      perl-Compress-Zlib < %{version}-%{release}
Provides:       perl-Compress-Zlib = %{version}-%{release}
Obsoletes:      perl-IO-Compress-Base < %{version}-%{release}
Provides:       perl-IO-Compress-Base = %{version}-%{release}
Obsoletes:      perl-IO-Compress-Bzip2 < %{version}-%{release}
Provides:       perl-IO-Compress-Bzip2 = %{version}-%{release}
Obsoletes:      perl-IO-Compress-Zlib < %{version}-%{release}
Provides:       perl-IO-Compress-Zlib = %{version}-%{release}

%description
This distribution provides a Perl interface to allow reading and writing of
compressed data created with the zlib and bzip2 libraries.

IO-Compress supports reading and writing of bzip2, RFC 1950, RFC 1951,
RFC 1952 (i.e. gzip) and zip files/buffers.

The following modules used to be distributed separately, but are now
included with the IO-Compress distribution:
* Compress-Zlib
* IO-Compress-Zlib
* IO-Compress-Bzip2
* IO-Compress-Base

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
AutoProv:	no

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n IO-Compress-%{version} -a 999

# Remove spurious exec permissions
chmod -c -x lib/IO/Uncompress/{Adapter/Identity,RawInflate}.pm
find examples -type f -exec chmod -c -x {} \;

# Fix shellbangs in examples
perl -pi -e 's|^#!/usr/local/bin/perl\b|#!%{__perl}|' examples/io/anycat \
        examples/io/bzip2/* examples/io/gzip/* examples/compress-zlib/*

%build
perl Makefile.PL
make %{?_smp_mflags}

%install
make pure_install DESTDIR=%{buildroot} INSTALLDIRS=perl
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
%{_fixperms} %{buildroot}

for dir in `cd fivextra; find . -type d -not -name CVS`
do
        install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
        install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find t -type d)
do
	install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
	install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in $(find examples -type d)
do
	install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
	install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
# Build using "--without long_tests" to avoid very long tests
# (full suite can take nearly an hour on an i7)
make test %{?with_long_tests:COMPRESS_ZLIB_RUN_ALL=1}

%files
%doc Changes README examples/*
%{_bindir}/zipdetails
%{perl_privlib}/Compress/
%{perl_privlib}/File/
%dir %{perl_privlib}/IO/
%dir %{perl_privlib}/IO/Compress/
%doc %{perl_privlib}/IO/Compress/FAQ.pod
%{perl_privlib}/IO/Compress/Adapter/
%{perl_privlib}/IO/Compress/Base/
%{perl_privlib}/IO/Compress/Base.pm
%{perl_privlib}/IO/Compress/Bzip2.pm
%{perl_privlib}/IO/Compress/Deflate.pm
%{perl_privlib}/IO/Compress/Gzip/
%{perl_privlib}/IO/Compress/Gzip.pm
%{perl_privlib}/IO/Compress/RawDeflate.pm
%{perl_privlib}/IO/Compress/Zip/
%{perl_privlib}/IO/Compress/Zip.pm
%{perl_privlib}/IO/Compress/Zlib/
%{perl_privlib}/IO/Uncompress/
%{_mandir}/man1/zipdetails.1*
%{_mandir}/man3/Compress::Zlib.3pm*
%{_mandir}/man3/File::GlobMapper.3pm*
%{_mandir}/man3/IO::Compress::*.3pm*
%{_mandir}/man3/IO::Uncompress::*.3pm*

%files fivextra
%{prefix}

%changelog
* Thu Jun 27 2013 baseuser@ibm.com
- Base-8.x spec file
