%global fontname    dejavu
%global archivename %{name}-%{archiveversion}

#global alphatag .20080512svn2226
#global alphatag .rc1

#global archiveversion 2.24-20080512-2226
%global archiveversion %{version}

# Common description
%global common_desc \
The DejaVu font set is based on the “Bitstream Vera” fonts, release 1.10. Its\
purpose is to provide a wider range of characters, while maintaining the \
original style, using an open collaborative development process.


Name:    %{fontname}-fonts
Version: 2.33
%define base_release .1
Release: 5%{?alphatag}%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary: DejaVu fonts

Group:     User Interface/X
License:   Bitstream Vera and Public Domain
URL:       http://%{name}.org/
Source0:   %{?!alphatag:http://downloads.sourceforge.net/%{fontname}}%{?alphatag:%{fontname}.sourceforge.net/snapshots}/%{archivename}.tar.bz2


# Older fontforge versions will not work due to sfd format changes
BuildRequires: fontforge >= 20080429
BuildRequires: perl(Font::TTF)
# Needed to compute unicode coverage
BuildRequires: unicode-ucd

BuildArch:     noarch
BuildRequires: fontpackages-devel

%description
%common_desc


%package common
Summary:  Common files for the Dejavu font set
Requires: fontpackages-filesystem

Obsoletes: dejavu-fonts-doc < 2.26-6
Obsoletes: %{name}-compat < 2.29-3
Obsoletes: %{name}-lgc-compat < 2.29-3

%description common
%common_desc

This package consists of files used by other DejaVu packages.


%package -n %{fontname}-sans-fonts
Summary:  Variable-width sans-serif font faces
Requires: %{name}-common = %{version}-%{release}

Conflicts: dejavu-fonts < 2.26-3
Conflicts: dejavu-fonts-experimental < 2.26-3

Obsoletes: %{name}-sans < 2.28-2

%description -n %{fontname}-sans-fonts
%common_desc

This package consists of the DejaVu sans-serif variable-width font faces, in
their unabridged version.

%_font_pkg -n sans -f *-%{fontname}-sans.conf DejaVuSans.ttf DejaVuSans-*.ttf DejaVuSansCondensed*.ttf


%package -n %{fontname}-serif-fonts
Summary:  Variable-width serif font faces
Requires: %{name}-common = %{version}-%{release}

Conflicts: dejavu-fonts < 2.26-3
Conflicts: dejavu-fonts-experimental < 2.26-3

Obsoletes: %{name}-serif < 2.28-2

%description -n %{fontname}-serif-fonts
%common_desc

This package consists of the DejaVu serif variable-width font faces, in their
unabridged version.

%_font_pkg -n serif -f *-%{fontname}-serif.conf DejaVuSerif.ttf DejaVuSerif-*.ttf DejaVuSerifCondensed*.ttf


%package -n %{fontname}-sans-mono-fonts
Summary:  Monospace sans-serif font faces
Requires: %{name}-common = %{version}-%{release}

Conflicts: dejavu-fonts < 2.26-3
Conflicts: dejavu-fonts-experimental < 2.26-3

Obsoletes: %{name}-sans-mono < 2.28-2

%description -n %{fontname}-sans-mono-fonts
%common_desc

This package consists of the DejaVu sans-serif monospace font faces, in their
unabridged version.

%_font_pkg -n sans-mono -f *-%{fontname}-sans-mono.conf DejaVuSansMono*.ttf


%package -n %{fontname}-lgc-sans-fonts
Summary:  Variable-width sans-serif font faces, Latin-Greek-Cyrillic subset
Requires: %{name}-common = %{version}-%{release}

Conflicts: dejavu-lgc-fonts < 2.26-3

Obsoletes: %{name}-lgc-sans < 2.28-2

%description -n %{fontname}-lgc-sans-fonts
%common_desc

This package consists of the DejaVu sans-serif variable-width font faces, with
unicode coverage restricted to Latin, Greek and Cyrillic.

%_font_pkg -n lgc-sans -f *-%{fontname}-lgc-sans.conf DejaVuLGCSans.ttf DejaVuLGCSans-*.ttf DejaVuLGCSansCondensed*.ttf


%package -n %{fontname}-lgc-serif-fonts
Summary:  Variable-width serif font faces, Latin-Greek-Cyrillic subset
Requires: %{name}-common = %{version}-%{release}

Conflicts: dejavu-lgc-fonts < 2.26-3

Obsoletes: %{name}-lgc-serif < 2.28-2

%description -n %{fontname}-lgc-serif-fonts
%common_desc

This package consists of the DejaVu serif variable-width font faces, with
unicode coverage restricted to Latin, Greek and Cyrillic.

%_font_pkg -n lgc-serif -f *-%{fontname}-lgc-serif.conf DejaVuLGCSerif.ttf DejaVuLGCSerif-*.ttf DejaVuLGCSerifCondensed*.ttf


%package -n %{fontname}-lgc-sans-mono-fonts
Summary:  Monospace sans-serif font faces, Latin-Greek-Cyrillic subset
Requires: %{name}-common = %{version}-%{release}

Conflicts: dejavu-lgc-fonts < 2.26-3

Obsoletes: %{name}-lgc-sans-mono < 2.28-2

%description -n %{fontname}-lgc-sans-mono-fonts
%common_desc

This package consists of the DejaVu sans-serif monospace font faces, with
unicode coverage restricted to Latin, Greek and Cyrillic.

%_font_pkg -n lgc-sans-mono -f *-%{fontname}-lgc-sans-mono.conf DejaVuLGCSansMono*.ttf


%prep
%setup -q -n %{archivename}

%build
make %{?_smp_mflags} VERSION=%{version} FC-LANG="" \
     BLOCKS=/usr/share/unicode/ucd/Blocks.txt UNICODEDATA=/usr/share/unicode/ucd/UnicodeData.txt

# Stop the desktop people from complaining this file is too big
bzip2 -9 build/status.txt


%check
make check


%install
rm -fr %{buildroot}

install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p build/*.ttf %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

cd fontconfig
for fontconf in *conf ; do
  install -m 0644 -p $fontconf %{buildroot}%{_fontconfig_templatedir}
  ln -s %{_fontconfig_templatedir}/$fontconf \
        %{buildroot}%{_fontconfig_confdir}/$fontconf
done


%clean
rm -fr %{buildroot}


%files common
%defattr(0644,root,root,0755)
%doc AUTHORS BUGS LICENSE NEWS README
%doc build/unicover.txt build/status.txt.bz2


%changelog
* Wed May 28 2014 baseuser@ibm.com
- Base-f19.x spec file
