%if 0%{?cross_build}
%global tests_enabled 0
%else
%global tests_enabled 1
%endif

Summary: System and process monitoring utilities
Name: procps-ng
Version: 3.3.7
%define base_release .3
Release: 3%{?dist}%{?base_release}
License: GPLv2+ and LGPLv2+
Group: Applications/System
URL: https://sourceforge.net/projects/procps-ng/

Source: http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.xz

Patch0: procps-ng-3.3.7-testsuite-reverting-bogus-commit-unix-exp.patch
Patch1: procps-ng-3.3.7-segv-file2str-read-zero-bytes.patch

Patch98280: bug98280-adjustment-for-configure-macro.patch

Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

BuildRequires: ncurses-devel
BuildRequires: libtool
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gettext-devel

%if %{tests_enabled}
BuildRequires: dejagnu
%endif

Provides: procps = %{version}-%{release}
Obsoletes: procps < 3.2.9-1

# usrmove hack - will be removed once initscripts are fixed
Provides: /sbin/sysctl
Provides: /bin/ps

%description
The procps package contains a set of system utilities that provide
system information. Procps includes ps, free, skill, pkill, pgrep,
snice, tload, top, uptime, vmstat, w, watch and pwdx. The ps command
displays a snapshot of running processes. The top command provides
a repetitive update of the statuses of running processes. The free
command displays the amounts of free and used memory on your
system. The skill command sends a terminate command (or another
specified signal) to a specified set of processes. The snice
command is used to change the scheduling priority of specified
processes. The tload command prints a graph of the current system
load average to a specified tty. The uptime command displays the
current time, how long the system has been running, how many users
are logged on, and system load averages for the past one, five,
and fifteen minutes. The w command displays a list of the users
who are currently logged on and what they are running. The watch
program watches a running program. The vmstat command displays
virtual memory statistics about processes, memory, paging, block
I/O, traps, and CPU activity. The pwdx command reports the current
working directory of a process or processes.

%package devel
Summary:  System and process monitoring utilities
Group:    Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}
Provides: procps-devel = %{version}-%{release}
Obsoletes: procps-devel < 3.2.9-1

%description devel
System and process monitoring utilities development headers

%prep
%setup -q -n %{name}-%{version}

%patch0 -p1
%patch1 -p1

%patch98280 -p1

%build
# The following stuff is needed for git archives only
#echo "%{version}" > .tarball-version
#./autogen.sh

autoreconf --verbose --force --install

%configure  --docdir=/unwanted \
            --disable-static \
            --disable-w-from \
            --disable-kill \
            --disable-rpath


make CFLAGS="%{optflags}"


%if %{tests_enabled}
%check
make check
%endif


%install
make DESTDIR=%{buildroot} install

mkdir -p %{buildroot}%{_sysconfdir}/sysctl.d

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc AUTHORS Documentation/BUGS COPYING COPYING.LIB Documentation/FAQ NEWS README top/README.top Documentation/TODO

%{_libdir}/libprocps.so.*
%{_bindir}/*
%{_sbindir}/*
%{_sysconfdir}/sysctl.d
%{_mandir}/man1/*
%{_mandir}/man8/*
%{_mandir}/man5/*

%exclude %{_libdir}/libprocps.la
%exclude %{_sysconfdir}/sysctl.conf
%exclude /unwanted/*

%files devel
%doc COPYING COPYING.LIB
%{_libdir}/libprocps.so
%{_libdir}/pkgconfig/libprocps.pc
%{_includedir}/proc

%changelog
* Wed Jun 19 2013 baseuser@ibm.com
- Base-8.x spec file
