%global	libauditver	2.1.3-4
%global libsepolver	2.1.9-1
%global	libsemanagever	2.1.10-1
%global	libselinuxver	2.1.13-1
%global	sepolgenver	1.1.9

Summary: SELinux policy core utilities
Name:	 policycoreutils
Version: 2.1.14
%define base_release .5
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Release: 74%{?dist}%{?base_release}
License: GPLv2
Group:	 System Environment/Base
# Based on git repository with tag 20101221
Source:	git://oss.tresys.com/git/selinux/policycoreutils-%{version}.tgz
Source1:git://oss.tresys.com/git/selinux/sepolgen-%{sepolgenver}.tgz
URL:	 http://www.selinuxproject.org
Source2: policycoreutils_man_ru2.tar.bz2
Source3: system-config-selinux.png
Patch:	 policycoreutils-rhat.patch
Patch1:	 policycoreutils-sepolgen.patch
Obsoletes: policycoreutils < 2.0.61-2
Conflicts: filesystem < 3
Provides: /sbin/fixfiles
Provides: /sbin/restorecon

BuildRequires:	pam-devel libcgroup-devel libsepol-static >= %{libsepolver} libsemanage-static >= %{libsemanagever} libselinux-devel >= %{libselinuxver}  libcap-devel audit-libs-devel >=  %{libauditver} gettext
BuildRequires: desktop-file-utils dbus-devel dbus-glib-devel
BuildRequires: python-devel setools-devel >= 3.3.7-14
Requires:	/bin/mount /bin/egrep /bin/awk /usr/bin/diff rpm /bin/sed
Requires: libsepol >= %{libsepolver} coreutils libselinux-utils >=  %{libselinuxver}

%description
Security-enhanced Linux is a feature of the Linux® kernel and a number
of utilities with enhanced security functionality designed to add
mandatory access controls to Linux.  The Security-enhanced Linux
kernel contains new architectural components originally developed to
improve the security of the Flask operating system. These
architectural components provide general support for the enforcement
of many kinds of mandatory access control policies, including those
based on the concepts of Type Enforcement®, Role-based Access
Control, and Multi-level Security.

policycoreutils contains the policy core utilities that are required
for basic operation of a SELinux system.  These utilities include
load_policy to load policies, setfiles to label filesystems, newrole
to switch roles.

%prep
%setup -q -a 1
%patch -p2 -b .rhat
%patch1 -p2 -b .sepolgen -d sepolgen-%{sepolgenver}

%build
cp %{SOURCE3} gui/
make LSPP_PRIV=y SBINDIR="%{_sbindir}" LIBDIR="%{_libdir}" CFLAGS="%{optflags} -fPIE" LDFLAGS="-pie -Wl,-z,relro -Wl,-z,now" SEMODULE_PATH="/usr/sbin" all
make -C sepolgen-%{sepolgenver} SBINDIR="%{_sbindir}" LSPP_PRIV=y LIBDIR="%{_libdir}" CFLAGS="%{optflags} -fPIE" LDFLAGS="-pie -Wl,-z,relro" all

%install
mkdir -p %{buildroot}/var/lib/selinux
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_sbindir}
mkdir -p %{buildroot}%{_mandir}/man1
mkdir -p %{buildroot}%{_mandir}/man5
mkdir -p %{buildroot}%{_mandir}/man8
%{__mkdir} -p %{buildroot}/%{_usr}/share/doc/%{name}/
cp COPYING %{buildroot}/%{_usr}/share/doc/%{name}/

make LSPP_PRIV=y  DESTDIR="%{buildroot}" SBINDIR="%{buildroot}%{_sbindir}" LIBDIR="%{buildroot}%{_libdir}" SEMODULE_PATH="/usr/sbin" install

# Systemd
rm -rf %{buildroot}/%{_sysconfdir}/rc.d/init.d/restorecond

make -C sepolgen-%{sepolgenver} DESTDIR="%{buildroot}" SBINDIR="%{buildroot}%{_sbindir}" LIBDIR="%{buildroot}%{_libdir}" install

tar -jxf %{SOURCE2} -C %{buildroot}/
rm -f %{buildroot}/usr/share/man/ru/man8/genhomedircon.8.gz
rm -f %{buildroot}/usr/share/man/ru/man8/open_init_pty.8.gz
rm -f %{buildroot}/usr/share/man/man8/open_init_pty.8
rm -f %{buildroot}/usr/sbin/open_init_pty

ln -sf /usr/share/system-config-selinux/polgengui.py %{buildroot}%{_bindir}/selinux-polgengui

desktop-file-install --dir ${RPM_BUILD_ROOT}%{_datadir}/applications	\
			--add-category Settings				\
%{buildroot}%{_datadir}/system-config-selinux/system-config-selinux.desktop

desktop-file-install --dir ${RPM_BUILD_ROOT}%{_datadir}/applications	\
%{buildroot}%{_datadir}/system-config-selinux/selinux-polgengui.desktop

rm -f %{buildroot}%{_datadir}/system-config-selinux/selinux-polgengui.desktop
rm -f %{buildroot}%{_datadir}/system-config-selinux/system-config-selinux.desktop

%find_lang %{name}

%package python
Summary: SELinux policy core python utilities
Group:	 System Environment/Base
Requires:policycoreutils = %{version}-%{release}
Requires:libsemanage-python >= %{libsemanagever} libselinux-python libcgroup
Requires:audit-libs-python >=  %{libauditver}
Requires(pre): python >= 2.6
Obsoletes: policycoreutils < 2.0.61-2
Requires: python-IPy yum

%description python
The policycoreutils-python package contains the management tools use to manage
an SELinux environment.

%files python
%{_sbindir}/semanage
%{_bindir}/chcat
%{_bindir}/sandbox
%{_bindir}/audit2allow
%{_bindir}/audit2why
%{_mandir}/man1/audit2allow.1*
%{_mandir}/ru/man1/audit2allow.1*
%{_mandir}/man1/audit2why.1*
%{python_sitearch}/seobject.py*
%{python_sitearch}/sepolgen
%dir %{python_sitearch}/sepolicy
%{python_sitearch}/sepolicy/*so
%{python_sitearch}/sepolicy/templates
%{python_sitearch}/sepolicy/__init__.py*
%{python_sitearch}/sepolicy/booleans.py*
%{python_sitearch}/sepolicy/communicate.py*
%{python_sitearch}/sepolicy/interface.py*
%{python_sitearch}/sepolicy/manpage.py*
%{python_sitearch}/sepolicy/network.py*
%{python_sitearch}/sepolicy/transition.py*
%{python_sitearch}/sepolicy/sedbus.py*
%{_sysconfdir}/dbus-1/system.d/org.fedoraproject.selinux.conf
%{python_sitearch}/%{name}*.egg-info
%{python_sitearch}/sepolicy*.egg-info
%{python_sitearch}/%{name}
%dir  /var/lib/selinux
%{_mandir}/man8/chcat.8*
%{_mandir}/ru/man8/chcat.8*
%{_mandir}/man8/sandbox.8*
%{_mandir}/man8/semanage*.8*
%{_mandir}/ru/man8/semanage.8*
%{_datadir}/system-config-selinux/selinux_server.py
%{_datadir}/dbus-1/system/org.fedoraproject.selinux.service
%{_datadir}/polkit-1/actions/org.fedoraproject.selinux.policy
%{_datadir}/bash-completion/completions/semanage
%{_datadir}/bash-completion/completions/setsebool

%package devel
Summary: SELinux policy core policy devel utilities
Group:	 System Environment/Base
Requires: policycoreutils-python = %{version}-%{release}
Requires: /usr/bin/make
Requires: checkpolicy
Requires: selinux-policy-devel

%description devel
The policycoreutils-devel package contains the management tools use to develop policy in an SELinux environment.

%files devel
%{_bindir}/sepolgen
%{_bindir}/sepolgen-ifgen
%{_bindir}/sepolgen-ifgen-attr-helper
%dir  /var/lib/sepolgen
/var/lib/sepolgen/perm_map
%{_bindir}/sepolicy
%{python_sitearch}/sepolicy/generate.py*
%{_mandir}/man8/sepolgen.8*
%{_mandir}/man8/sepolicy-booleans.8*
%{_mandir}/man8/sepolicy-generate.8*
%{_mandir}/man8/sepolicy-interface.8*
%{_mandir}/man8/sepolicy-network.8*
%{_mandir}/man8/sepolicy.8*
%{_mandir}/man8/sepolicy-communicate.8*
%{_mandir}/man8/sepolicy-manpage.8*
%{_mandir}/man8/sepolicy-transition.8*
%{_usr}/share/bash-completion/completions/sepolicy

%package sandbox
Summary: SELinux sandbox utilities
Group:	 System Environment/Base
Requires: policycoreutils-python = %{version}-%{release}
Requires: xorg-x11-server-Xephyr >= 1.14.1-2 /usr/bin/rsync /usr/bin/xmodmap
Requires: openbox
BuildRequires: openbox
BuildRequires: libcap-ng-devel

%description sandbox
The policycoreutils-sandbox package contains the scripts to create graphical
sandboxes

%files sandbox
%config(noreplace) %{_sysconfdir}/sysconfig/sandbox
%{_datadir}/sandbox/sandboxX.sh
%{_datadir}/sandbox/start
%caps(cap_setpcap,cap_setuid,cap_fowner,cap_dac_override,cap_sys_admin,cap_sys_nice=pe) %{_sbindir}/seunshare
%{_mandir}/man8/seunshare.8*
%{_mandir}/man5/sandbox.5*

%package newrole
Summary: The newrole application for RBAC/MLS
Group: System Environment/Base
Requires: policycoreutils = %{version}-%{release}

%description newrole
RBAC/MLS policy machines require newrole as a way of changing the role
or level of a logged in user.

%files newrole
%attr(0755,root,root) %caps(cap_dac_read_search,cap_setpcap,cap_audit_write,cap_sys_admin,cap_fowner,cap_chown,cap_dac_override=pe) %{_bindir}/newrole

%{_mandir}/man1/newrole.1.gz
%config(noreplace) %{_sysconfdir}/pam.d/newrole

%package gui
Summary: SELinux configuration GUI
Group: System Environment/Base
Requires: policycoreutils-devel = %{version}-%{release}
Requires: gnome-python2-gnome, pygtk2, pygtk2-libglade, gnome-python2-canvas
Requires: usermode-gtk
Requires: python >= 2.6
BuildRequires: desktop-file-utils

%description gui
system-config-selinux is a utility for managing the SELinux environment

%files gui
%{_bindir}/system-config-selinux
%{_bindir}/selinux-polgengui
%{_datadir}/applications/system-config-selinux.desktop
%{_datadir}/applications/selinux-polgengui.desktop
%{_datadir}/icons/hicolor/24x24/apps/system-config-selinux.png
%{_datadir}/pixmaps/system-config-selinux.png
%{_datadir}/polkit-1/actions/org.fedoraproject.config.selinux.policy
%dir %{_datadir}/system-config-selinux
%{_datadir}/system-config-selinux/system-config-selinux.png
%{_datadir}/system-config-selinux/*.py*
%{_datadir}/system-config-selinux/*.glade
%{python_sitearch}/sepolicy/gui.py*
%{python_sitearch}/sepolicy/sepolicy.glade
%{_mandir}/man8/system-config-selinux.8*
%{_mandir}/man8/selinux-polgengui.8*
%{_mandir}/man8/sepolicy-gui.8*

%post gui
/bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null || :

%postun gui
if [ $1 -eq 0 ] ; then
    /bin/touch --no-create %{_datadir}/icons/hicolor &>/dev/null
    /usr/bin/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :
fi

%posttrans gui
/usr/bin/gtk-update-icon-cache %{_datadir}/icons/hicolor &>/dev/null || :

%files -f %{name}.lang
%{_sbindir}/restorecon
%{_sbindir}/fixfiles
%{_sbindir}/setfiles
%{_sbindir}/run_init
%{_sbindir}/load_policy
%{_sbindir}/genhomedircon
%{_sbindir}/setsebool
%{_sbindir}/semodule
%{_sbindir}/sestatus
%{_bindir}/secon
%{_bindir}/semodule_deps
%{_bindir}/semodule_expand
%{_bindir}/semodule_link
%{_bindir}/semodule_package
%{_bindir}/semodule_unpackage
%config(noreplace) %{_sysconfdir}/sestatus.conf
%config(noreplace) %{_sysconfdir}/pam.d/run_init
# selinux-policy Requires: policycoreutils, so we own this set of directories and our files within them
%{_mandir}/man5/selinux_config.5.gz
%{_mandir}/man5/sestatus.conf.5.gz
%{_mandir}/man8/fixfiles.8*
%{_mandir}/ru/man8/fixfiles.8*
%{_mandir}/man8/run_init.8*
%{_mandir}/ru/man8/run_init.8*
%{_mandir}/man8/load_policy.8*
%{_mandir}/ru/man8/load_policy.8*
%{_mandir}/man8/restorecon.8*
%{_mandir}/ru/man8/restorecon.8*
%{_mandir}/man8/semodule.8*
%{_mandir}/ru/man8/semodule.8*
%{_mandir}/man8/semodule_deps.8*
%{_mandir}/ru/man8/semodule_deps.8*
%{_mandir}/man8/semodule_expand.8*
%{_mandir}/ru/man8/semodule_expand.8*
%{_mandir}/man8/semodule_link.8*
%{_mandir}/ru/man8/semodule_link.8*
%{_mandir}/man8/semodule_package.8*
%{_mandir}/man8/semodule_unpackage.8*
%{_mandir}/ru/man8/semodule_package.8*
%{_mandir}/man8/sestatus.8*
%{_mandir}/ru/man8/sestatus.8*
%{_mandir}/man8/setfiles.8*
%{_mandir}/ru/man8/setfiles.8*
%{_mandir}/man8/setsebool.8*
%{_mandir}/ru/man8/setsebool.8*
%{_mandir}/man1/secon.1*
%{_mandir}/ru/man1/secon.1*
%{_mandir}/man8/genhomedircon.8*
%doc %{_usr}/share/doc/%{name}

%package restorecond
Summary: SELinux restorecond utilities
Group:	 System Environment/Base
BuildRequires:	systemd-units
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units

%description restorecond
The policycoreutils-restorecond package contains the restorecond service.

%files restorecond
%{_sbindir}/restorecond
%{_unitdir}/restorecond.service
%config(noreplace) %{_sysconfdir}/selinux/restorecond.conf
%config(noreplace) %{_sysconfdir}/selinux/restorecond_user.conf
%{_sysconfdir}/xdg/autostart/restorecond.desktop
%{_datadir}/dbus-1/services/org.selinux.Restorecond.service
%{_mandir}/man8/restorecond.8*
%{_mandir}/ru/man8/restorecond.8*

%post restorecond
%systemd_post restorecond.service

%preun restorecond
%systemd_preun restorecond.service

%postun restorecond
%systemd_postun_with_restart restorecond.service

%changelog
* Thu Jan 23 2014 baseuser@ibm.com
- Base-f19.x spec file
