# if 0%{?rhel} && 0%{?rhel} < 6
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
# endif

# Python3 support is 3.3+ (which was introduced in Fedora 18)
%if 0%{?fedora} && 0%{?fedora} >= 18 && ! 0%{?base:1}
%global with_python3 1
%endif

# LTC: disable docs
%if ! 0%{?base:1}
%global with_docs 1
%endif

Name:           python-simplejson

Version:        3.5.3
%define base_release .1
Release:        1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch:   mips64 ppc476 ppcnf ppca2
Summary:        Simple, fast, extensible JSON encoder/decoder for Python

Group:          System Environment/Libraries
# The main code is licensed MIT.
# The docs include jquery which is licensed MIT or GPLv2
License: (MIT or AFL) and (MIT or GPLv2)
URL:            http://undefined.org/python/#simplejson
Source0:        http://pypi.python.org/packages/source/s/simplejson/simplejson-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  python2-devel
BuildRequires:  python-setuptools
BuildRequires:  python-nose
%if 0%{?with_docs}
BuildRequires: python-sphinx
%endif
%if 0%{?with_python3}
BuildRequires: python3-devel
BuildRequires: python3-setuptools
BuildRequires: python3-nose
%endif # with_python3

# we don't want to provide private python extension libs
%global __provides_exclude_from ^(%{python_sitearch}|%{python3_sitearch}).*\\.so$


%description
simplejson is a simple, fast, complete, correct and extensible JSON
<http://json.org> encoder and decoder for Python 2.5+. It is pure Python code
with no dependencies, but includes an optional C extension for a serious speed
boost.

The encoder may be subclassed to provide serialization in any kind of
situation, without any special support by the objects to be serialized
(somewhat like pickle).

The decoder can handle incoming JSON strings of any specified encoding (UTF-8
by default).

simplejson is the externally maintained development version of the json library
included with Python 2.6 and Python 3.0, but maintains backwards compatibility
with Python 2.5.  It gets updated more regularly than the json module in the
python stdlib.

%if 0%{?with_python3}
%package -n python3-simplejson
Summary:        Simple, fast, extensible JSON encoder/decoder for Python3
Group:          System Environment/Libraries

%description -n python3-simplejson
simplejson is a simple, fast, complete, correct and extensible JSON
<http://json.org> encoder and decoder for Python 2.5+ and python3.3+ It is pure
Python code with no dependencies, but includes an optional C extension for a
serious speed boost.

The encoder may be subclassed to provide serialization in any kind of
situation, without any special support by the objects to be serialized
(somewhat like pickle).

The decoder can handle incoming JSON strings of any specified encoding (UTF-8
by default).

simplejson is the externally maintained development version of the json library
included with Python 2.6 and Python 3.0, but maintains backwards compatibility
with Python 2.5.  It gets updated more regularly than the json module in the
python stdlib.

%endif # with_python3

%prep
%setup -q -n simplejson-%{version}

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3

%build
%{__python} setup.py build
%if 0%{?with_docs}
./scripts/make_docs.py
%endif

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3

%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root=%{buildroot}

%if 0%{?with_docs}
rm docs/.buildinfo
rm docs/.nojekyll
%endif

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root=%{buildroot}
popd
%endif # with_python3

%check
nosetests -q

%if 0%{?with_python3}
pushd %{py3dir}
nosetests-%{python3_version} -q
popd
%endif # with_python3

%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root,-)
%if 0%{?with_docs}
%doc docs LICENSE.txt
%endif
%{python_sitearch}/*

%if 0%{?with_python3}
%files -n python3-simplejson
%defattr(-,root,root,-)
%doc LICENSE.txt
%{python3_sitearch}/*
%endif # python3

%changelog
* Thu Jul 31 2014 baseuser@ibm.com
- Base-8.x spec file
