#ifndef __DEBUG_H__
#define __DEBUG_H__

void spicex_log(unsigned int type, const char *function, const char *format, ...);
void spicex_init_logger(void);
void spicex_log_cleanup(void);

#ifdef WIN32
#define snprintf _snprintf
#endif

#define ON_PANIC() ::abort()

#ifdef SPICEX_DEBUG

#define ASSERTBREAK DebugBreak()

#define ASSERT(x) if (!(x)) {                               \
    printf("%s: ASSERT %s failed\n", __FUNCTION__, #x);     \
    ASSERTBREAK;                                            \
}

#else

#define ASSERT(cond)

#endif

enum {
  LOG_FATAL = 1,
  LOG_ERROR,
  LOG_WARN,
  LOG_INFO,
  LOG_DEBUG,
};

#define LOG(type, format, ...) spicex_log(type, __FUNCTION__, format, ## __VA_ARGS__)

#define LOG_INFO(format, ...) LOG(LOG_INFO, format, ## __VA_ARGS__)
#define LOG_WARN(format, ...) LOG(LOG_WARN, format, ## __VA_ARGS__)
#define LOG_ERROR(format, ...) LOG(LOG_ERROR, format, ## __VA_ARGS__)

#define DBG(level, format, ...)                         \
        LOG(LOG_DEBUG + level, format, ## __VA_ARGS__)



#endif // __DEBUG_H__
