----------------------------------
-- 		create functions		--
----------------------------------

IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'FN' AND NAME = 'getGlobalIds')
BEGIN
    -- Constraint is not used dropping it to clean the dependency before dropping the function.
    if exists (SELECT name FROM sysobjects WHERE  object_name(parent_obj)='permissions' and  
			   xtype = 'D' and name = 'DF_permissions_object_id_system')
	BEGIN
		ALTER TABLE permissions drop constraint DF_permissions_object_id_system
	END
	EXEC('Drop Function getGlobalIds')
END
GO

print 'Step 1 done.'
go


CREATE FUNCTION [dbo].[getGlobalIds] (@name nvarchar(max) )  
returns uniqueidentifier  As  

BEGIN 
DECLARE @id uniqueidentifier
if (@name = 'system')
	set @id = 'AAA00000-0000-0000-0000-123456789AAA'
else if (@name = 'everyone')
	set @id = 'EEE00000-0000-0000-0000-123456789EEE'
 return  @id
END
GO

print 'Step 2 done.'
go


IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'TF' AND NAME = 'fnSplitter')
BEGIN
	EXEC('Drop Function fnSplitter')
END
GO

print 'Step 3 done.'
go


CREATE Function fnSplitter (@IDs nvarchar(max) )  
Returns @Tbl_IDs Table  (ID nvarchar(max))  As  

Begin 
 -- Append comma
 Set @IDs =  @IDs + ',' 
 -- Indexes to keep the position of searching
 Declare @Pos1 Int
 Declare @pos2 Int
 
 -- Start from first character 
 Set @Pos1=1
 Set @Pos2=1

 While @Pos1<Len(@IDs)
 Begin
  Set @Pos1 = CharIndex(',',@IDs,@Pos1)
  Insert @Tbl_IDs Select  Substring(@IDs,@Pos2,@Pos1-@Pos2)
  -- Go to next non comma character
  Set @Pos2=@Pos1+1
  -- Search from the next charcater
  Set @Pos1 = @Pos1+1
 End 
 Return
End
GO

print 'Step 4 done.'
go

IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'TF' AND NAME = 'fn_user_permissions')
BEGIN
	EXEC('Drop Function fn_user_permissions')
END
GO

print 'Step 5 done.'
go

--All permissions of current user (include groups)
Create Function [dbo].fn_user_permissions (@user_id as uniqueidentifier)
    returns @user_permissions Table
    (
    permission_id uniqueidentifier,
    role_id uniqueidentifier,
    user_id uniqueidentifier
    )
    as
    begin
    insert @user_permissions
    
    select 
    permissions.id as permission_id,
    permissions.role_id,
    permissions.ad_element_id as user_id
    from permissions inner join users on permissions.ad_element_id = users.user_id
    where users.user_id = @user_id 

    union

    select 
    permissions.id as permission_id,
    permissions.role_id,
    temp.user_id as user_id
    from permissions inner join
    (
    -- get all groups of admin users
    select ad_groups.id group_id, users.user_id
    from ad_groups, users
    where ad_groups.name in 
    (select id from fnSplitter(users.groups)) and users.user_id = @user_id) temp
    on permissions.ad_element_id = temp.group_id

    return
end
GO

print 'Step 6 done.'
go


IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'TF' AND NAME = 'get_all_child_roles_of_role')
BEGIN
	EXEC('Drop Function get_all_child_roles_of_role')
END
GO

print 'Step 7 done.'
go

create function get_all_child_roles_of_role(@roleId uniqueidentifier)

returns @temp table (id uniqueidentifier)

as

begin
insert into @temp (id) values  (@roleId);
with c(role_id, role_container_id)

as

(

	select role_id, role_container_id from roles_relations
	where role_container_id = @roleId
	union all
	select t.role_id, t.role_container_id
	from c join roles_relations t on c.role_id = t.role_container_id

)
insert into @temp

select distinct role_id from c

return

end
GO

print 'Step 8 done.'
go


IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'TF' AND NAME = 'fn_get_entity_parents')
BEGIN
	EXEC('Drop Function fn_get_entity_parents')
END
GO

print 'Step 9 done.'
go


CREATE function [dbo].[fn_get_entity_parents](@entity_id uniqueidentifier,@object_type int)
returns @entity_id_table table (id uniqueidentifier)

/*	Gets a list of all parent GUID to the system root (including)

	Object Types (compatible with VdcObjectType, XXX entries are unused currently)
		Unknown XXX,
		System XXX,
		VM = 2,
		VDS = 3,
		VmTemplate = 4,
		VmPool = 5,
		AdElements XXX,
		Tags XXX,
		Bookmarks XXX,
		VdsGroups = 9,
		MultiLevelAdministration XXX,
		Storage = 11,
		EventNotification XXX,
		ImportExport XXX,
		StoragePool = 14,
		User = 15,
		Role = 16
*/
as

begin
	-- variables
	declare @system_root_id uniqueidentifier
	declare @cluster_id uniqueidentifier
	declare @ds_id uniqueidentifier
	declare @image_id uniqueidentifier

	set @system_root_id = dbo.getGlobalIds('system') -- hardcoded also in MLA Handler
	if (@object_type = 2) -- VM
	begin
        -- get cluster id
		select @cluster_id = vds_group_id 
		from vm_static
		where vm_guid = @entity_id
		-- get data center id
		select @ds_id = storage_pool_id
		from vds_groups
		where vds_group_id = @cluster_id

		insert into @entity_id_table (id) 
		(
		select @system_root_id
		union
		select @ds_id 
		union
		select @cluster_id
		union
		select @entity_id)
	end

	else if (@object_type = 3) -- VDS
	begin

        -- get cluster id		
		select @cluster_id = vds_group_id 
		from vds_static
		where vds_id = @entity_id
		-- get data center id
		select @ds_id = storage_pool_id
		from vds_groups
		where vds_group_id = @cluster_id

		insert into @entity_id_table (id) 
		(
		select @system_root_id
		union
		select @ds_id 
		union
		select @cluster_id
		union
		select @entity_id)

	end

	else if (@object_type = 4) -- Template
	begin
		-- get image id first
		select top 1 @image_id =  it_guid from vm_template_image_map
							where vmt_guid = @entity_id
		-- get the storage id from images
		declare @storage_id uniqueidentifier
		select @storage_id =  storage_id from images
							where image_guid = @image_id			
		-- finally get data center id
		select @ds_id = storage_pool_id
		from storage_pool_iso_map
		where storage_id = @storage_id

		insert into @entity_id_table (id) 
		(
		select @system_root_id
		union
		select @ds_id
		union
		select @entity_id)

	end

	else if (@object_type = 5) -- VM Pool
	begin
        -- get cluster id
		select @cluster_id = vds_group_id 
		from vm_pools
		where vm_pool_id = @entity_id
		-- get data center id
		select @ds_id = storage_pool_id
		from vds_groups
		where vds_group_id = @cluster_id

		insert into @entity_id_table (id) 
		(
		select @system_root_id
		union
		select @ds_id 
		union
		select @cluster_id
		union
		select @entity_id)

	end

	else if (@object_type = 9) -- Cluster
	begin
		-- get data center id
		select @ds_id = storage_pool_id
		from vds_groups
		where vds_group_id = @entity_id

		insert into @entity_id_table (id)
		(
		select @system_root_id
		union
		select @ds_id
		union
		select @entity_id)

	end

	else if (@object_type in (1,14,11,15,16)) -- Data Center, storage, users and roles are under system
	begin
		-- get data center id
		insert into @entity_id_table (id) 
		(
			select @system_root_id
			union
			select @entity_id)
			
	end
return

end
go

print 'Step 10 done.'
go


IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'FN' AND NAME = 'fn_get_disk_commited_value_by_storage')
BEGIN
	EXEC('Drop Function dbo.fn_get_disk_commited_value_by_storage')
END
GO

print 'Step 11 done.'
go


CREATE FUNCTION [dbo].[fn_get_disk_commited_value_by_storage]
(
	@storage_domain_id uniqueidentifier
)
RETURNS int
AS
BEGIN
declare @result int
declare @from_byte_to_GB float
set @from_byte_to_GB = 0.000000000931322574615478515625
select @result = isnull(sum((size - actual_size) * @from_byte_to_GB), 0)
from vm_images_view
where storage_id = @storage_domain_id 
	RETURN @result
END
GO

print 'Step 12 done.'
go


IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'FN' AND NAME = 'fn_get_storage_domain_shared_status_by_domain_id')
BEGIN
	EXEC('Drop Function dbo.fn_get_storage_domain_shared_status_by_domain_id')
END
GO

print 'Step 13 done.'
go


CREATE FUNCTION [dbo].[fn_get_storage_domain_shared_status_by_domain_id]
(
	@storage_domain_id uniqueidentifier,
	@storage nvarchar(250),
	@storage_type int
)
RETURNS int
AS
BEGIN
	declare @result int
	declare @temp Table (status int, [count] int)
	delete from @temp
	declare @rowsCount int
	Insert @temp 
	select status, count(storage_id) from storage_pool_iso_map 
	where storage_id = @storage_domain_id
	group by status

	select @rowsCount = count(*) from @temp

	-- if return 0 rows then the domain is unattached (0) or locked (4) if storage is null or empty for @storage_type iscsi (2) and fcp (3)
	if (@rowsCount = 0)
		begin
			if (@storage_type in (2,3) and (@storage is null or @storage = ''))
				set @result = 4
			else
				set @result = 0
		end
	else if (@rowsCount = 1)
		begin
			declare @status int 
			select top 1 @status = status from @temp
			-- if 1 row and status active (3) then domain is active (1)
			if @status = 3
				set @result = 1
			-- if 1 row and status not active then domain is inactive (2)
			else
				set @result = 2
		end
	-- else (if return more then 1 row) 
	else
		begin
			-- the domain is mixed (3) only if one of the statuses is active
			select @rowsCount = count(*) from @temp where status = 3
			if (@rowsCount > 0)
				set @result = 3
			-- non of the statuses is active
			else
				set @result = 2
		end
	return @result
END
GO

print 'Step 14 done.'
go


IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'FN' AND NAME = 'fn_get_ad_element_name')
BEGIN
	EXEC('Drop Function fn_get_ad_element_name')
END
GO

print 'Step 15 done.'
go


CREATE function [dbo].[fn_get_ad_element_name](@ad_element_id uniqueidentifier)
returns nvarchar(max)
	-- this function returns user/group name by id
as
begin
	declare @name nvarchar(max)
	if (@ad_element_id = dbo.getGlobalIds('everyone'))
		begin		
			set @name = 'Everyone'
		end
	else
	begin
		select @name = (COALESCE(name,'') + ' ' + COALESCE(surname,'') + ' (' + COALESCE(username,'') + ')') from users 
			where user_id = @ad_element_id
		if (@name is null)
			begin
				select @name = name from ad_groups where id = @ad_element_id
			end
	end
	return @name
end
go

print 'Step 16 done.'
go


IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'FN' AND NAME = 'fn_get_entity_name')
BEGIN
	EXEC('Drop Function fn_get_entity_name')
END
GO

print 'Step 17 done.'
go


CREATE function [dbo].[fn_get_entity_name](@entity_id uniqueidentifier,@object_type int)
returns nvarchar(max)

/*	Gets object name by its id and type
	
	Object Types (compatible with VdcObjectType, XXX entries are unused currently)
		Unknown XXX,
		System XXX,
		VM = 2,
		VDS = 3,
		VmTemplate = 4,
		VmPool = 5,
		AdElements XXX,
		Tags XXX,
		Bookmarks XXX,
		VdsGroups = 9,
		MultiLevelAdministration XXX,
		Storage = 11,
		EventNotification XXX,
		ImportExport XXX,
		StoragePool = 14,
		User = 15,
		Role = 16
*/
as
begin

	declare @object_name nvarchar(max)

	if (@object_type = 1) -- System
		begin
			set @object_name = 'System'
		end
	else if (@object_type = 2) -- VM
		begin
			select @object_name = vm_name from vm_static with (nolock) where vm_guid = @entity_id
		end
	else if (@object_type = 3) -- VDS
		begin
			select @object_name = vds_name from vds_static with (nolock) where vds_id = @entity_id
		end
	else if (@object_type = 4) -- Template
		begin
			select @object_name = [name] from vm_templates with (nolock) where vmt_guid = @entity_id
		end
	else if (@object_type = 5) -- VM Pool
		begin
			select @object_name = vm_pool_name from vm_pools with (nolock) where vm_pool_id = @entity_id
		end
	else if (@object_type = 9) -- Cluster
		begin
			select @object_name = [name] from vds_groups with (nolock) where vds_group_id = @entity_id
		end
	else if (@object_type = 11) -- Storage
		begin
			select @object_name = [storage_name] from storage_domain_static with (nolock) where id = @entity_id
		end
	else if (@object_type = 14) -- Data Center
		begin
			select @object_name = [name] from storage_pool with (nolock) where id = @entity_id
		end

	return @object_name

end
go

print 'Step 18 done.'
go



-- get user and his groups IDs

IF EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'TF' AND NAME = 'getUserAndGroupsById')
BEGIN
	EXEC('Drop Function getUserAndGroupsById')
END
GO

print 'Step 19 done.'
go


CREATE FUNCTION [dbo].[getUserAndGroupsById] (@id as uniqueidentifier )
returns @temp table (id uniqueidentifier) as

BEGIN
insert @temp
select id from ad_groups,users where users.user_id = @id
		and ad_groups.name in (select id from fnSplitter(users.groups))
UNION
select @id
return
END
GO

print 'Step 20 done.'
go




