using System;
using System.Globalization;
using System.Text.RegularExpressions;
using System.Collections.Generic;

namespace org.ovirt.engine.ui.uicommon.validation
{
	public class AsciiOrNoneValidation : IValidation
	{
		#region Constants

		public const string ONLY_ASCII_OR_NONE = "[^\x00-\x7F]";

		#endregion

		public ValidationResult Validate(object value)
		{
			ValidationResult result = new ValidationResult();
			//note: in backend java code the regex is [\\p{ASCII}]* which is not compatible with c#
			if (value != null && Regex.IsMatch(value.ToString(), ONLY_ASCII_OR_NONE, RegexOptions.None))
			{
				result.Success = false;
				result.Reasons = new List<string>()
				                 	{
				                 		"The field contains special characters. Only numbers, letters, '-' and '_' are allowed."
				                 	};
			}
			return result;
		}
	}
}