using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows;
using System.Collections;
using VdcCommon.BusinessEntities;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class UserGroupListModel : ListModel
	{
		#region Properties

		public new DbUser Entity
		{
			get { return base.Entity as DbUser; }
			set { base.Entity = value; }
		}

		#endregion

		public UserGroupListModel()
		{
			Title = "Directory Groups";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (Entity != null)
			{
				List<UserGroup> items = new List<UserGroup>();
				foreach (string groupFullName in Entity.groups.Split(','))
				{
					items.Add(CreateUserGroup(groupFullName));
				}

				Items = items;
			}
			else
			{
				Items = null;
			}
		}

		private static UserGroup CreateUserGroup(string groupFullName)
		{
			// Parse 'groupFullName' (representation: Domain/OrganizationalUnit/Group)
			int firstIndexOfSlash = groupFullName.IndexOf('/');
			int lastIndexOfSlash = groupFullName.LastIndexOf('/');
			string domain = firstIndexOfSlash >= 0 ? groupFullName.Substring(0, firstIndexOfSlash) : "";
			string groupName = lastIndexOfSlash >= 0 ? groupFullName.Substring(lastIndexOfSlash+1) : "";
			string organizationalUnit = lastIndexOfSlash > firstIndexOfSlash ? 
				groupFullName.Remove(lastIndexOfSlash).Substring(firstIndexOfSlash+1) : "";

			return new UserGroup
			{
				GroupName = groupName,
				OrganizationalUnit = organizationalUnit,
				Domain = domain
			};
		}

		class UserGroup
		{
			public string GroupName { get; set; }
			public string OrganizationalUnit { get; set; }
			public string Domain { get; set; }
		}
	}
}
