using VdcCommon.BusinessEntities;

namespace SearchBackend
{
    class ClusterConditionFieldAutoCompleter :BaseConditionFieldAutoCompleter
    {
        public ClusterConditionFieldAutoCompleter()
        {
            //Building the basic vervs Dict
            mVerbs.Add("NAME", "NAME");
            mVerbs.Add("DESCRIPTION", "DESCRIPTION");
            mVerbs.Add("INITIALIZED", "INITIALIZED");
            
            //Building the autoCompletion Dict
            buildCompletions();
            //Building the types dict
            TypeDictionary.Add("NAME", typeof(string));
            TypeDictionary.Add("DESCRIPTION", typeof(string));
            TypeDictionary.Add("INITIALIZED", typeof(bool));
            
            //building the ColumnName Dict
            mColumnNameDict.Add("NAME", "name");
            mColumnNameDict.Add("DESCRIPTION", "description");
            mColumnNameDict.Add("INITIALIZED", "is_initialized");
            
            //Building the validation dict
            buildBasicValidationTable();
        }

        public override IAutoCompleter getFieldRelationshipAutoCompleter(string fieldName)
        {
			 IAutoCompleter retval;
			 switch (fieldName)
			 {
				 default:
					 retval = new StringConditionRelationAutoCompleter();
					 break;
			 }
            
            return retval;
        }

        public override IConditionValueAutoCompleter getFieldValueAutoCompleter(string fieldName)
        {
            IConditionValueAutoCompleter retval = null;
            switch (fieldName)
            {
                case "INITIALIZED":
                    retval = new BitValueAutoCompleter();
                    break;
                default:
                    break;
            }
            return retval;
        }

    }
    
}
