﻿using System;
using System.Reflection;
using System.ServiceModel;
using VdcUtils;
using VdcCommon.BusinessEntities;
using System.Configuration;

namespace VdcFrontend
{
	public abstract class BackendException : ApplicationException
	{
	}

	public class BackendCreationException : BackendException
	{
		public override string Message
		{
			get
			{
				return "Failed to create oVirt Backend";
			}
		}
	}

	public class BackendNotExistException : BackendException
	{
		public override string Message
		{
			get
			{
				return "oVirt Service not found";
			}
		}
	}

	public class BackendCommunicationException : BackendException
	{
		public override string Message
		{
			get
			{
				return "Failed to connect to the oVirt Service";
			}
		}
	}

	[Serializable]
	public class BackendFaultException : BackendException
	{
		public override string Message
		{
			get
			{
				return "oVirt Fault. Possible reasons: Session ended or Service is down";
			}
		}
	}

	public class PublicServicesCommunicationException : BackendException
	{
		public override string Message
		{
			get
			{
				return "Failed to Connect to oVirt Public Services";
			}
		}
	}

	public class BackendLoginException : BackendException
	{
		public override string Message
		{
			get
			{
				return "Failed to authenticate user login.";
			}
		}
	}

	public class BackendUserNotLoggedInException : BackendException
	{
		public override string Message
		{
			get
			{
				return "User is not logged in. This might have occurred because of a session time-out.";
			}
		}
	}

	static class WCFFactory
	{
		private static readonly ChannelFactory<IBackend> _publicServicesFactory = new ChannelFactory<IBackend>("wsBinding_IPublicServices");
		private static IBackend _publicServices;

		#region Backend

		internal static IBackend CreateBackend()
		{
			Backend = new ChannelFactory<IBackend>(ConfigurationManager.AppSettings[ClientConfigValues.RemoteInterface.ToString()]).CreateChannel();

			return Backend;
		}

		internal static IBackend GetBackend()
		{
			if (Backend == null)
			{
				throw new BackendNotExistException();
			}

			return Backend;
		}
		#endregion

		private static IBackend CreatePublicServices()
		{
			if (_publicServices != null)
			{
				ICommunicationObject publicServices = _publicServices as ICommunicationObject;
				if (publicServices != null)
				{
					publicServices.Abort();
				}
			}

			_publicServices = _publicServicesFactory.CreateChannel();
			ICommunicationObject publicServiceCommunicationObject =
				_publicServices as ICommunicationObject;
			if (publicServiceCommunicationObject == null)
			{
				throw new PublicServicesCommunicationException();
			}
			return _publicServices;
		}

		internal static IBackend PublicServices
		{
			get
			{
				_publicServices = CreatePublicServices();
				return _publicServices;
			}
		}

		internal static IBackend Backend
		{
			get;
			set;
		}
	}
}
