@echo off

if "%1%" == "-h" goto Syntax
if "%1%" == "--help" goto Syntax


SET sqlServer="%1%"
if "%1%" == "" set sqlServer=.\sqlexpress

SET dbname=%2%
if "%2%" == "" set dbname=rhevm

for %%v in (%0) do set MyPath=%%~dpv
pushd "%MyPath%"

SET user=%3%
if "%3%" == "" set user=sa

SET pass=%4%
if "%4%" == "" set pass=RHEVMadmin2009!

SET xmlconfigfile=%5%
if "%xmlconfigfile%" == "" set xmlconfigfile=%MyPath%FieldsInVDCConfig.xml

SET dbcmd=-b -S %sqlServer% -d %dbname% -U %user% -P %pass% 

echo server - %sqlServer%
echo dbname - %dbname%
echo filename - %xmlconfigfile%

SET sp="exec Sync_update_config_values '%xmlconfigfile%'"
echo Synchronizing configuration in database with xml file settings .....
sqlcmd  %dbcmd% -i sync_sp.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
sqlcmd  %dbcmd% -Q %sp% 
if %ERRORLEVEL% NEQ 0 goto ERROR
sqlcmd  %dbcmd% -i attach_user_to_su_role.sql
if %ERRORLEVEL% NEQ 0 goto ERROR
echo Done.

popd

goto:EOF


:Syntax
echo sync_config.cmd [server] [dbname] [user] [password] [xmlconfigfile]
echo     server      - the sql server to access (default = .\sqlexpress)
echo     dbname      - the database name to access/create (default = rhevm)
echo	 user        - the dbo user name (default is to use integrated authentication)
echo	 password    - the dbo password (default is to use integrated authentication)
echo	 xmlconfigfile - Full path to FieldsInVDCConfig.xml file

goto:EOF

:ERROR
exit /b 1