@ECHO OFF

IF (%4)==() GOTO Usage
IF NOT (%5)==() set CA_STARTDATE=-startdate %5
IF (%5)==() set CA_STARTDATE=

cd /d %4

openssl x509 -text -in ca.pem | find "Subject Key Identifier"
if errorlevel 1 (goto NoAKI) else (goto WithAKI)

:NoAKI
openssl ca -batch -policy policy_match -config openssl.conf -cert ca.pem -in requests\%1 -keyfile private\ca.pem -passin pass:%6 -days %3 -out certs\%2 %CA_STARTDATE%
goto Exit

:WithAKI
openssl ca -batch -policy policy_match -config openssl.conf -extfile cert.conf -extensions v3_ca -cert ca.pem -in requests\%1 -keyfile private\ca.pem -passin pass:%6 -days %3 -out certs\%2 %CA_STARTDATE%
goto Exit

:Exit
REM >> c:\temp\t.out 2>&1
EXIT /B %ERRORLEVEL%

:Usage
ECHO SignReq.bat - Sign a certificate request (with ca key)
ECHO Usage: 
ECHO     SignReq [Request Filename] [Output certificate filename] [days to expire] [CA Directory] [startdate]
ECHO Where:
ECHO     Request Filename            = Filename of request file. must reside under requests directory.
ECHO     Output certificate filename = Filename of output file. will reside under certs directory.
ECHO     days to expire              = Amount of days till certificate expires.
ECHO     CA Directory                = Full path to CA directory
ECHO     startdate                   = in YYMMDDHHMMSSZ ANS1 format
ECHO	 Pass                        = Certificate password
Exit /B 1
